/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.store.rest.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplicationKeyGenerateRequest {
    @SerializedName(value="keyType")
    private KeyTypeEnum keyType = null;
    @SerializedName(value="validityTime")
    private String validityTime = null;
    @SerializedName(value="supportedGrantTypes")
    private List<String> supportedGrantTypes = new ArrayList<String>();
    @SerializedName(value="callbackUrl")
    private String callbackUrl = null;
    @SerializedName(value="accessAllowDomains")
    private List<String> accessAllowDomains = new ArrayList<String>();
    @SerializedName(value="scopes")
    private List<String> scopes = new ArrayList<String>();

    public ApplicationKeyGenerateRequest keyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(example="PRODUCTION", required=true, value="")
    public KeyTypeEnum getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
    }

    public ApplicationKeyGenerateRequest validityTime(String validityTime) {
        this.validityTime = validityTime;
        return this;
    }

    @ApiModelProperty(example="3600", required=true, value="")
    public String getValidityTime() {
        return this.validityTime;
    }

    public void setValidityTime(String validityTime) {
        this.validityTime = validityTime;
    }

    public ApplicationKeyGenerateRequest supportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    public ApplicationKeyGenerateRequest addSupportedGrantTypesItem(String supportedGrantTypesItem) {
        this.supportedGrantTypes.add(supportedGrantTypesItem);
        return this;
    }

    @ApiModelProperty(example="[&quot;client_credentials&quot;,&quot;password&quot;]", value="The grant types that are supported by the application")
    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public void setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    public ApplicationKeyGenerateRequest callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    @ApiModelProperty(example="", value="Callback URL")
    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public ApplicationKeyGenerateRequest accessAllowDomains(List<String> accessAllowDomains) {
        this.accessAllowDomains = accessAllowDomains;
        return this;
    }

    public ApplicationKeyGenerateRequest addAccessAllowDomainsItem(String accessAllowDomainsItem) {
        this.accessAllowDomains.add(accessAllowDomainsItem);
        return this;
    }

    @ApiModelProperty(example="[&quot;ALL&quot;]", required=true, value="Allowed domains for the access token")
    public List<String> getAccessAllowDomains() {
        return this.accessAllowDomains;
    }

    public void setAccessAllowDomains(List<String> accessAllowDomains) {
        this.accessAllowDomains = accessAllowDomains;
    }

    public ApplicationKeyGenerateRequest scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ApplicationKeyGenerateRequest addScopesItem(String scopesItem) {
        this.scopes.add(scopesItem);
        return this;
    }

    @ApiModelProperty(example="[&quot;am_application_scope&quot;,&quot;default&quot;]", value="Allowed scopes for the access token")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyGenerateRequest applicationKeyGenerateRequest = (ApplicationKeyGenerateRequest)o;
        return Objects.equals((Object)this.keyType, (Object)applicationKeyGenerateRequest.keyType) && Objects.equals(this.validityTime, applicationKeyGenerateRequest.validityTime) && Objects.equals(this.supportedGrantTypes, applicationKeyGenerateRequest.supportedGrantTypes) && Objects.equals(this.callbackUrl, applicationKeyGenerateRequest.callbackUrl) && Objects.equals(this.accessAllowDomains, applicationKeyGenerateRequest.accessAllowDomains) && Objects.equals(this.scopes, applicationKeyGenerateRequest.scopes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.keyType, this.validityTime, this.supportedGrantTypes, this.callbackUrl, this.accessAllowDomains, this.scopes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyGenerateRequest {\n");
        sb.append("    keyType: ").append(this.toIndentedString((Object)this.keyType)).append("\n");
        sb.append("    validityTime: ").append(this.toIndentedString(this.validityTime)).append("\n");
        sb.append("    supportedGrantTypes: ").append(this.toIndentedString(this.supportedGrantTypes)).append("\n");
        sb.append("    callbackUrl: ").append(this.toIndentedString(this.callbackUrl)).append("\n");
        sb.append("    accessAllowDomains: ").append(this.toIndentedString(this.accessAllowDomains)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KeyTypeEnum {
        PRODUCTION("PRODUCTION"),
        SANDBOX("SANDBOX");

        private String value;

        private KeyTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

