/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.store.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.Subscription;

public class SubscriptionMultitpleApi {
    private ApiClient apiClient;

    public SubscriptionMultitpleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionMultitpleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call subscriptionsMultiplePostCall(List<Subscription> body, String contentType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<Subscription> localVarPostBody = body;
        String localVarPath = "/subscriptions/multiple".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call subscriptionsMultiplePostValidateBeforeCall(List<Subscription> body, String contentType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling subscriptionsMultiplePost(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling subscriptionsMultiplePost(Async)");
        }
        Call call = this.subscriptionsMultiplePostCall(body, contentType, progressListener, progressRequestListener);
        return call;
    }

    public Subscription subscriptionsMultiplePost(List<Subscription> body, String contentType) throws ApiException {
        ApiResponse<Subscription> resp = this.subscriptionsMultiplePostWithHttpInfo(body, contentType);
        return resp.getData();
    }

    public ApiResponse<Subscription> subscriptionsMultiplePostWithHttpInfo(List<Subscription> body, String contentType) throws ApiException {
        Call call = this.subscriptionsMultiplePostValidateBeforeCall(body, contentType, null, null);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call subscriptionsMultiplePostAsync(List<Subscription> body, String contentType, final ApiCallback<Subscription> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.subscriptionsMultiplePostValidateBeforeCall(body, contentType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Subscription>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

