/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.store.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.APIList;

public class APICollectionApi {
    private ApiClient apiClient;

    public APICollectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public APICollectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call apisGetCall(Integer limit, Integer offset, String xWSO2Tenant, String query, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xWSO2Tenant != null) {
            localVarHeaderParams.put("X-WSO2-Tenant", this.apiClient.parameterToString(xWSO2Tenant));
        }
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisGetValidateBeforeCall(Integer limit, Integer offset, String xWSO2Tenant, String query, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.apisGetCall(limit, offset, xWSO2Tenant, query, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public APIList apisGet(Integer limit, Integer offset, String xWSO2Tenant, String query, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<APIList> resp = this.apisGetWithHttpInfo(limit, offset, xWSO2Tenant, query, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<APIList> apisGetWithHttpInfo(Integer limit, Integer offset, String xWSO2Tenant, String query, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.apisGetValidateBeforeCall(limit, offset, xWSO2Tenant, query, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<APIList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisGetAsync(Integer limit, Integer offset, String xWSO2Tenant, String query, String accept, String ifNoneMatch, final ApiCallback<APIList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisGetValidateBeforeCall(limit, offset, xWSO2Tenant, query, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<APIList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

