/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.store.rest.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiCallback;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiResponse;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Configuration;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.Pair;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressRequestBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ProgressResponseBody;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.SubscriptionList;

public class SubscriptionCollectionApi {
    private ApiClient apiClient;

    public SubscriptionCollectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionCollectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call subscriptionsGetCall(String apiId, String applicationId, String groupId, Integer offset, Integer limit, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/subscriptions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apiId", apiId));
        }
        if (applicationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "applicationId", applicationId));
        }
        if (groupId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "groupId", groupId));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call subscriptionsGetValidateBeforeCall(String apiId, String applicationId, String groupId, Integer offset, Integer limit, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling subscriptionsGet(Async)");
        }
        if (applicationId == null) {
            throw new ApiException("Missing the required parameter 'applicationId' when calling subscriptionsGet(Async)");
        }
        Call call = this.subscriptionsGetCall(apiId, applicationId, groupId, offset, limit, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public SubscriptionList subscriptionsGet(String apiId, String applicationId, String groupId, Integer offset, Integer limit, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<SubscriptionList> resp = this.subscriptionsGetWithHttpInfo(apiId, applicationId, groupId, offset, limit, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<SubscriptionList> subscriptionsGetWithHttpInfo(String apiId, String applicationId, String groupId, Integer offset, Integer limit, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.subscriptionsGetValidateBeforeCall(apiId, applicationId, groupId, offset, limit, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<SubscriptionList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call subscriptionsGetAsync(String apiId, String applicationId, String groupId, Integer offset, Integer limit, String accept, String ifNoneMatch, final ApiCallback<SubscriptionList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.subscriptionsGetValidateBeforeCall(apiId, applicationId, groupId, offset, limit, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SubscriptionList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

