/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.TenantUtils;
import org.wso2.carbon.apimgt.samples.utils.WebAppDeployUtils;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;

public class CreateSampleOneRawData {
    private static final String hostname = "localhost";
    private static final String port = "9443";
    private static final String serviceEndpoint = "https://localhost:9443/services/";
    private static final String warFileName = "sample-data-backend";
    private static final String warFileLocation = System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sample-data-backend.war";
    private static String clientTrustStore = System.getProperty("user.dir") + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks";

    public static void main(String[] args) throws ApiException, IOException {
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore"))) {
            System.setProperty("javax.net.ssl.trustStore", clientTrustStore);
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        System.out.println("Deploying sample back end");
        WebAppDeployUtils.deployWebApp((String)serviceEndpoint, (String)"admin", (String)"admin", (String)warFileLocation, (String)warFileName);
        CreateSampleOneRawData.createTenants();
        List<String> apiIds = CreateSampleOneRawData.createAPIs();
        CreateSampleOneRawData.publishAPIs(apiIds);
    }

    private static List<String> createAPIs() throws ApiException, IOException {
        ArrayList<String> apiIds = new ArrayList<String>();
        ArrayList<String> apiOneVisibleTenants = new ArrayList<String>();
        apiOneVisibleTenants.add("finance.abc.com");
        ArrayList<String> apiOneTags = new ArrayList<String>();
        apiOneTags.add("finance");
        apiIds.add(SampleUtils.createApi((String)"Salary_details_API", (String)"1.0.0", (String)"/salaries", new ArrayList(), apiOneVisibleTenants, (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)hostname, (String)port, apiOneTags));
        ArrayList<String> apiTwoVisibleTenants = new ArrayList<String>();
        apiTwoVisibleTenants.add("core.abc.com");
        ArrayList<String> apiTwoTags = new ArrayList<String>();
        apiTwoTags.add("stock");
        apiIds.add(SampleUtils.createApi((String)"Mobile_stock_API", (String)"1.0.0", (String)"/stocks", new ArrayList(), apiTwoVisibleTenants, (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)hostname, (String)port, apiTwoTags));
        ArrayList<String> apiThreeVisibleTenants = new ArrayList<String>();
        apiThreeVisibleTenants.add("operations.abc.com");
        ArrayList<String> apiThreeTags = new ArrayList<String>();
        apiThreeTags.add("maintenance");
        apiIds.add(SampleUtils.createApi((String)"Maintenance_ask_API", (String)"1.0.0", (String)"/tasks", new ArrayList(), apiThreeVisibleTenants, (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)hostname, (String)port, apiThreeTags));
        ArrayList<String> apiFourVisibleTenants = new ArrayList<String>();
        apiFourVisibleTenants.add("finance.abc.com");
        apiFourVisibleTenants.add("core.abc.com");
        ArrayList<String> apiFourTags = new ArrayList<String>();
        apiFourTags.add("employee");
        apiIds.add(SampleUtils.createApi((String)"Employee_info_API", (String)"1.0.0", (String)"/empInfo", new ArrayList(), apiFourVisibleTenants, (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)hostname, (String)port, apiFourTags));
        ArrayList<String> apiFiveTags = new ArrayList<String>();
        apiFiveTags.add("phone");
        apiIds.add(SampleUtils.createApi((String)"Phone_prices_API", (String)"1.0.0", (String)"/mobilePrices", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)hostname, (String)port, apiFiveTags));
        apiIds.add(SampleUtils.createApi((String)"Pouch_prices_API", (String)"1.0.0", (String)"/pouchPrices", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)hostname, (String)port, apiFiveTags));
        return apiIds;
    }

    private static void createTenants() {
        TenantUtils.createTenant((String)"john", (String)"123123", (String)"finance.abc.com", (String)" John", (String)"Smith", (String)serviceEndpoint);
        TenantUtils.createTenant((String)"tom", (String)"123123", (String)"core.abc.com", (String)" Tom", (String)"Smith", (String)serviceEndpoint);
        TenantUtils.createTenant((String)"bob", (String)"123123", (String)"operations.abc.com", (String)" Bob", (String)"Len", (String)serviceEndpoint);
    }

    private static void publishAPIs(List apiIdList) throws ApiException {
        for (Object apiId : apiIdList) {
            SampleUtils.publishAPI((String)((String)apiId));
        }
    }
}

