/*
 * Decompiled with CFR 0.152.
 */
import beans.RawDataBean;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.TenantUtils;
import org.wso2.carbon.apimgt.samples.utils.ThrottlingUtils;
import org.wso2.carbon.apimgt.samples.utils.WebAppDeployUtils;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleLimit;
import org.wso2.carbon.apimgt.samples.utils.beans.ApiBean;
import org.wso2.carbon.apimgt.samples.utils.beans.TenantBean;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;

public class CreateSampleTwoRawData {
    private static final String hostname = "localhost";
    private static final String port = "9443";
    private static final String serviceEndpoint = "https://localhost:9443/services/";
    private static List<RawDataBean> rawDataList = CreateSampleTwoRawData.createRawDataList();
    private static final String warFileName = "sample-data-backend";
    private static final String warFileLocation = System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sample-data-backend.war";
    private static String clientTrustStore = System.getProperty("user.dir") + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks";

    public static void main(String[] args) throws IOException, org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException, InterruptedException, ApiException {
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore"))) {
            System.setProperty("javax.net.ssl.trustStore", clientTrustStore);
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        System.out.println("Deploying sample back end");
        WebAppDeployUtils.deployWebApp((String)serviceEndpoint, (String)"admin", (String)"admin", (String)warFileLocation, (String)warFileName);
        CreateSampleTwoRawData.createTenants(rawDataList);
        CreateSampleTwoRawData.createThrottlePolicies();
        System.out.println("Waiting for tenant initialization...");
        CreateSampleTwoRawData.createAPIsForTenants(rawDataList);
        CreateSampleTwoRawData.publishAPIs(rawDataList);
        ArrayList<String> apiFourVisibleTenants = new ArrayList<String>();
        apiFourVisibleTenants.add("finance.abc.com");
        apiFourVisibleTenants.add("core.abc.com");
        ArrayList<String> apiFourTags = new ArrayList<String>();
        apiFourTags.add("employee");
        String apiId = SampleUtils.createApi((String)"Employee_info_API", (String)"1.0.0", (String)"/empInfo", new ArrayList(), apiFourVisibleTenants, (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)hostname, (String)port, apiFourTags);
        SampleUtils.publishAPI((String)apiId);
    }

    private static void createTenants(List<RawDataBean> rawDataBeans) {
        for (RawDataBean rawDataBean : rawDataBeans) {
            TenantBean tenant = rawDataBean.getTenant();
            TenantUtils.createTenant((String)tenant.getAdminUser(), (String)tenant.getAdminPwd(), (String)tenant.getDomain(), (String)tenant.getAdminFirstName(), (String)tenant.getAdminLastName(), (String)serviceEndpoint);
            System.out.println(tenant.getDomain() + " added successfully");
        }
    }

    private static void createAPIsForTenants(List<RawDataBean> rawDataBeans) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException, IOException, InterruptedException {
        for (RawDataBean rawDataBean : rawDataBeans) {
            ApiBean api = rawDataBean.getApi();
            TenantBean tenant = rawDataBean.getTenant();
            String apiId = SampleUtils.createApiForTenant((String)api.getApiName(), (String)api.getApiVersion(), (String)api.getApiContext(), (API.VisibilityEnum)API.VisibilityEnum.PUBLIC, new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.CURRENT_TENANT, (String)hostname, (String)port, (ArrayList)api.getTagList(), (String)tenant.getDomain(), (String)tenant.getAdminUser(), (String)tenant.getAdminPwd());
            api.setApiId(apiId);
            rawDataBean.setApi(api);
            rawDataBeans.set(rawDataBean.getId(), rawDataBean);
            System.out.println("Waiting the tenant " + tenant.getDomain() + " to be loaded...");
            System.out.println("API " + api.getApiName() + "-" + api.getApiVersion() + "created successfully.");
        }
        rawDataList = rawDataBeans;
    }

    private static void publishAPIs(List<RawDataBean> rawDataBeans) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        for (RawDataBean rawDataBean : rawDataBeans) {
            ApiBean api = rawDataBean.getApi();
            TenantBean tenant = rawDataBean.getTenant();
            SampleUtils.publishAPI((String)api.getApiId(), (String)tenant.getDomain(), (String)tenant.getAdminUser(), (String)tenant.getAdminPwd());
            System.out.println("API " + api.getApiName() + "-" + api.getApiVersion() + " published to store.");
        }
    }

    private static List<RawDataBean> createRawDataList() {
        TenantBean tenant1 = new TenantBean();
        tenant1.setDomain("finance.abc.com");
        tenant1.setAdminUser("john");
        tenant1.setAdminPwd("123123");
        tenant1.setAdminFirstName("John");
        tenant1.setAdminLastName("Smith");
        TenantBean tenant2 = new TenantBean();
        tenant2.setDomain("core.abc.com");
        tenant2.setAdminUser("tom");
        tenant2.setAdminPwd("123123");
        tenant2.setAdminFirstName("Tom");
        tenant2.setAdminLastName("Smith");
        TenantBean tenant3 = new TenantBean();
        tenant3.setDomain("operations.abc.com");
        tenant3.setAdminUser("bob");
        tenant3.setAdminPwd("123123");
        tenant3.setAdminFirstName("Bob");
        tenant3.setAdminLastName("Len");
        ApiBean api1 = new ApiBean();
        api1.setApiName("Salary_details_API");
        api1.setApiVersion("1.0.0");
        api1.setApiContext("/t/" + tenant1.getDomain() + "/salaries");
        ArrayList<String> tagList1 = new ArrayList<String>();
        tagList1.add("finance");
        api1.setTagList(tagList1);
        ApiBean api2 = new ApiBean();
        api2.setApiName("Mobile_stock_API");
        api2.setApiVersion("1.0.0");
        api2.setApiContext("/t/" + tenant2.getDomain() + "/stocks");
        ArrayList<String> tagList2 = new ArrayList<String>();
        tagList2.add("stock");
        api2.setTagList(tagList2);
        ApiBean api3 = new ApiBean();
        api3.setApiName("Maintenance_ask_API");
        api3.setApiVersion("1.0.0");
        api3.setApiContext("/t/" + tenant3.getDomain() + "/tasks");
        ArrayList<String> tagList3 = new ArrayList<String>();
        tagList3.add("maintenance");
        api3.setTagList(tagList3);
        RawDataBean rawDataBean1 = new RawDataBean();
        rawDataBean1.setId(0);
        rawDataBean1.setApi(api1);
        rawDataBean1.setTenant(tenant1);
        RawDataBean rawDataBean2 = new RawDataBean();
        rawDataBean2.setId(1);
        rawDataBean2.setApi(api2);
        rawDataBean2.setTenant(tenant2);
        RawDataBean rawDataBean3 = new RawDataBean();
        rawDataBean3.setId(2);
        rawDataBean3.setApi(api3);
        rawDataBean3.setTenant(tenant3);
        ArrayList<RawDataBean> rawDataBeanList = new ArrayList<RawDataBean>();
        rawDataBeanList.add(rawDataBean1);
        rawDataBeanList.add(rawDataBean2);
        rawDataBeanList.add(rawDataBean3);
        return rawDataBeanList;
    }

    private static void createThrottlePolicies() throws ApiException, InterruptedException {
        ThrottlingUtils.addAdvanceThrottlePolicyForTenants((String)"100KPerMin", (String)"100KPerMin", (String)"Allows 100000 requests per minute", (String)"min", (Integer)1, (long)100000L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT, (long)0L, null, (String)"finance.abc.com", (String)"john", (String)"123123");
        Thread.sleep(2000L);
        ThrottlingUtils.addAdvanceThrottlePolicyForTenants((String)"100KPerMin", (String)"100KPerMin", (String)"Allows 100000 requests per minute", (String)"min", (Integer)1, (long)100000L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT, (long)0L, null, (String)"core.abc.com", (String)"tom", (String)"123123");
        Thread.sleep(2000L);
        ThrottlingUtils.addAdvanceThrottlePolicyForTenants((String)"100KPerMin", (String)"100KPerMin", (String)"Allows 100000 requests per minute", (String)"min", (Integer)1, (long)100000L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT, (long)0L, null, (String)"operations.abc.com", (String)"bob", (String)"123123");
        Thread.sleep(2000L);
    }
}

