/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.HTTPSClientUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.WebAppDeployUtils;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKey;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKeyGenerateRequest;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.Subscription;

public class CreateSampleFourRawData {
    private static final String hostname = "localhost";
    private static final String port = "9443";
    private static final String serviceEndpoint = "https://localhost:9443/services/";
    private static final String warFileName = "sample-data-backend";
    private static final String warFileLocation = System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sample-data-backend.war";
    private static String clientTrustStore = System.getProperty("user.dir") + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks";
    private static final String gatewayPort = "8243";
    private static final String gatewayHost = "localhost";
    private static final String getGatewayEndpoint = "https://localhost:8243";

    public static void main(String[] args) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException, IOException, ApiException {
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore"))) {
            System.setProperty("javax.net.ssl.trustStore", clientTrustStore);
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        System.out.println("Deploying sample back end");
        WebAppDeployUtils.deployWebApp((String)serviceEndpoint, (String)"admin", (String)"admin", (String)warFileLocation, (String)warFileName);
        List<String> apiIds = CreateSampleFourRawData.createAPIs();
        CreateSampleFourRawData.publishAPIs(apiIds);
        String accessTokenOne = CreateSampleFourRawData.subscribeToAPI(apiIds.get(0), "Application_one");
        CreateSampleFourRawData.invokeAPI(accessTokenOne, 1, "/salariesSecure/1.0.0/salary/1");
        String accessTokenTwo = CreateSampleFourRawData.subscribeToAPIWithNewScope(apiIds.get(1), "Application_two");
        CreateSampleFourRawData.invokeAPI(accessTokenTwo, 1, "/salariesSecure/1.0.0/salary/1");
    }

    private static List<String> createAPIs() throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException, IOException {
        ArrayList<String> apiIds = new ArrayList<String>();
        ArrayList<String> apiOneVisibleTenants = new ArrayList<String>();
        apiOneVisibleTenants.add("finance.abc.com");
        ArrayList<String> apiOneTags = new ArrayList<String>();
        apiOneTags.add("finance");
        apiIds.add(SampleUtils.createApi((String)"Salary_details_API", (String)"1.0.0", (String)"/salariesSecure", new ArrayList(), apiOneVisibleTenants, (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)"localhost", (String)port, apiOneTags));
        ArrayList<String> apiFiveTags = new ArrayList<String>();
        apiFiveTags.add("phone");
        apiIds.add(SampleUtils.createApi((String)"Phone_prices_API", (String)"1.0.0", (String)"/mobilePrices", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)"localhost", (String)port, apiFiveTags));
        return apiIds;
    }

    private static void publishAPIs(List apiIdList) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        for (Object apiId : apiIdList) {
            SampleUtils.publishAPI((String)((String)apiId));
        }
    }

    private static String subscribeToAPI(String apiIdOne, String applicationName) throws ApiException {
        System.out.println("Creating Application One");
        String applicationIdOne = SampleUtils.createApplication((String)applicationName, (String)"This a new application created", (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("refresh_token");
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ArrayList<String> allowedDomain = new ArrayList<String>();
        allowedDomain.add("ALL");
        System.out.println("Generating keys for Application One");
        ApplicationKey applicationKey = SampleUtils.generateKeys((String)applicationIdOne, (String)"7200", null, (ApplicationKeyGenerateRequest.KeyTypeEnum)ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION, new ArrayList(), allowedDomain, grantTypes);
        String accessToken = applicationKey.getToken().getAccessToken();
        System.out.println("Creating a subscription for keys for Application One");
        SampleUtils.createSubscription((String)apiIdOne, (String)applicationIdOne, (String)"Unlimited", (Subscription.StatusEnum)Subscription.StatusEnum.UNBLOCKED);
        return accessToken;
    }

    private static String subscribeToAPIWithNewScope(String apiIdOne, String applicationName) throws ApiException {
        System.out.println("Creating Application Two");
        String applicationIdOne = SampleUtils.createApplication((String)applicationName, (String)"This a new application created", (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("refresh_token");
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ArrayList<String> allowedDomain = new ArrayList<String>();
        allowedDomain.add("ALL");
        ArrayList<String> allowedSopes = new ArrayList<String>();
        allowedSopes.add("new_scope");
        System.out.println("Generating keys for Application One");
        ApplicationKey applicationKey = SampleUtils.generateKeys((String)applicationIdOne, (String)"7200", null, (ApplicationKeyGenerateRequest.KeyTypeEnum)ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION, allowedSopes, allowedDomain, grantTypes);
        String accessToken = applicationKey.getToken().getAccessToken();
        System.out.println("Creating a subscription for keys for Application Two");
        SampleUtils.createSubscription((String)apiIdOne, (String)applicationIdOne, (String)"Unlimited", (Subscription.StatusEnum)Subscription.StatusEnum.UNBLOCKED);
        return accessToken;
    }

    private static void invokeAPI(String accessToken, int invocationNumber, String apiResourcePath) throws IOException {
        HashMap<String, String> requestHeadersOne = new HashMap<String, String>();
        requestHeadersOne.put("Authorization", "Bearer " + accessToken);
        System.out.print("Invoking API using Application One to get analytics data");
        for (int i = 1; i <= invocationNumber; ++i) {
            HTTPSClientUtils.doGet((String)(getGatewayEndpoint + apiResourcePath), requestHeadersOne);
            System.out.print(".");
        }
        System.out.println("");
    }
}

