/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.LifecycleUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.ServerUtils;
import org.wso2.carbon.apimgt.samples.utils.WebAppDeployUtils;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKeyGenerateRequest;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.Subscription;
import org.wso2.carbon.governance.lcm.stub.LifeCycleManagementServiceExceptionException;
import org.wso2.carbon.server.admin.stub.ServerAdminException;

public class CreateSampleSevenRawData {
    private static final String hostname = "localhost";
    private static final String port = "9443";
    private static final String serviceEndpoint = "https://localhost:9443/services/";
    private static final String warFileName = "sample-data-backend";
    private static final String warFileLocation = System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sample-data-backend.war";
    private static final String clientTrustStore = System.getProperty("user.dir") + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks";

    public static void main(String[] args) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException, IOException, ServerAdminException, InterruptedException, LifeCycleManagementServiceExceptionException, ApiException {
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore"))) {
            System.setProperty("javax.net.ssl.trustStore", clientTrustStore);
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        if (StringUtils.isEmpty((String)System.getProperty("carbon.home"))) {
            System.setProperty("carbon.home", "../../");
        }
        WebAppDeployUtils.deployWebApp((String)serviceEndpoint, (String)"admin", (String)"admin", (String)warFileLocation, (String)warFileName);
        System.out.println("Creating Salary_details_API API");
        String apiIdOne = SampleUtils.createApi((String)"Salary_details_API", (String)"1.0.0", (String)"/salaries", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)hostname, (String)port, new ArrayList());
        System.out.println("Publishing Salary_details_API API");
        if (StringUtils.isNotEmpty((String)apiIdOne)) {
            SampleUtils.publishAPI((String)apiIdOne);
        }
        System.out.println("Creating Employee_info_API API");
        SampleUtils.createApi((String)"Employee_info_API", (String)"1.0.0", (String)"/empInfo", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)hostname, (String)port, new ArrayList());
        System.out.println("Creating Mobile_stock_API API");
        String apiIdThree = SampleUtils.createApi((String)"Mobile_stock_API", (String)"1.0.0", (String)"/stocks", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)hostname, (String)port, new ArrayList());
        System.out.println("Deprecating Mobile_stock_API API");
        if (StringUtils.isNotEmpty((String)apiIdThree)) {
            SampleUtils.publishAPI((String)apiIdThree);
        }
        if (StringUtils.isNotEmpty((String)apiIdThree)) {
            SampleUtils.deprecateAPI((String)apiIdThree);
        }
        String apiIdFour = null;
        System.out.println("Creating new version of Mobile_stock_API API");
        if (StringUtils.isNotEmpty((String)apiIdThree)) {
            apiIdFour = SampleUtils.createNewAPIVersion((String)"2.0.0", (String)apiIdThree);
            System.out.println("Publishing new version of Mobile_stock_API API");
            if (StringUtils.isNotEmpty((String)apiIdFour)) {
                SampleUtils.publishAPI((String)apiIdFour);
            }
        }
        System.out.println("Creating Sales_promotions_API 2.0.0 API");
        String apiIdFive = SampleUtils.createApi((String)"Sales_promotions_API", (String)"2.0.0", (String)"/promo", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.ALL_TENANTS, (String)hostname, (String)port, new ArrayList());
        System.out.println("Blocking Sales_promotions_API 2.0.0 API");
        if (StringUtils.isNotEmpty((String)apiIdFive)) {
            SampleUtils.publishAPI((String)apiIdFive);
        }
        if (StringUtils.isNotEmpty((String)apiIdFive)) {
            SampleUtils.blockAPI((String)apiIdFive);
        }
        System.out.println("Adding custom state(REJECT) to API lifecycle");
        LifecycleUtils.updateLifecycle((String)serviceEndpoint, (String)"admin", (String)"admin", (String)"APILifeCycle");
        ServerUtils.restartServer((String)serviceEndpoint, (String)"admin", (String)"admin");
        ServerUtils.waitForServerStartup((String)serviceEndpoint, (String)"admin", (String)"admin");
        System.out.println("Creating Sales_promotions_API 1.0.0 API");
        if (StringUtils.isNotEmpty((String)apiIdFive)) {
            String apiIdSix = SampleUtils.createNewAPIVersion((String)"1.0.0", (String)apiIdFive);
            System.out.println("Rejecting Sales_promotions_API 1.0.0 API");
            if (StringUtils.isNotEmpty((String)apiIdSix)) {
                SampleUtils.publishAPI((String)apiIdSix);
            }
            if (StringUtils.isNotEmpty((String)apiIdSix)) {
                SampleUtils.rejectAPI((String)apiIdSix);
            }
        }
        System.out.println("Creating Application(Application_one) in store");
        String applicationIdOne = SampleUtils.createApplication((String)"Application_one", (String)"This a new application created", (String)"Unlimited");
        if (StringUtils.isNotEmpty((String)applicationIdOne)) {
            ArrayList<String> grantTypes = new ArrayList<String>();
            grantTypes.add("refresh_token");
            grantTypes.add("password");
            grantTypes.add("client_credentials");
            ArrayList<String> allowedDomain = new ArrayList<String>();
            allowedDomain.add("ALL");
            SampleUtils.generateKeys((String)applicationIdOne, (String)"7200", null, (ApplicationKeyGenerateRequest.KeyTypeEnum)ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION, new ArrayList(), allowedDomain, grantTypes);
            System.out.println("Salary_details_API subscribing to Application_one");
            if (StringUtils.isNotEmpty((String)apiIdOne)) {
                SampleUtils.createSubscription((String)apiIdOne, (String)applicationIdOne, (String)"Unlimited", (Subscription.StatusEnum)Subscription.StatusEnum.UNBLOCKED);
            }
            System.out.println("Sales_promotions_API subscribing to Application_one");
            if (StringUtils.isNotEmpty((String)apiIdFour)) {
                SampleUtils.createSubscription((String)apiIdFour, (String)applicationIdOne, (String)"Unlimited", (Subscription.StatusEnum)Subscription.StatusEnum.UNBLOCKED);
            }
        }
        System.out.println("Sample scenario seven data populated successfully.");
    }
}

