/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.WebAppDeployUtils;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;

public class CreateSampleEightRawData {
    private static final String hostname = "localhost";
    private static final String port = "9443";
    private static final String serviceEndpoint = "https://localhost:9443/services/";
    private static final String warFileName = "sample-data-backend";
    private static final String warFileLocation = System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sample-data-backend.war";
    private static String clientTrustStore = System.getProperty("user.dir") + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks";

    public static void main(String[] args) throws ApiException, IOException {
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore"))) {
            System.setProperty("javax.net.ssl.trustStore", clientTrustStore);
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        System.out.println("Deploying sample back end");
        WebAppDeployUtils.deployWebApp((String)serviceEndpoint, (String)"admin", (String)"admin", (String)warFileLocation, (String)warFileName);
        String oldApiId = SampleUtils.createApi((String)"Mobile_stock_API", (String)"1.0.0", (String)"/stocks", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.SPECIFIC_TENANTS, (String)hostname, (String)port, new ArrayList());
        SampleUtils.publishAPI((String)oldApiId);
        SampleUtils.deprecateAPI((String)oldApiId);
        String newApiId = SampleUtils.createNewAPIVersion((String)"2.0.0", (String)oldApiId);
        SampleUtils.publishAPI((String)newApiId);
    }
}

