/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.HTTPSClientUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.TenantUtils;
import org.wso2.carbon.apimgt.samples.utils.ThrottlingUtils;
import org.wso2.carbon.apimgt.samples.utils.UserManagementUtils;
import org.wso2.carbon.apimgt.samples.utils.WebAppDeployUtils;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleLimit;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKey;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKeyGenerateRequest;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.Subscription;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class CreateSampleNineRawData {
    private static final String hostname = "localhost";
    private static final String port = "9443";
    private static final String gatewayPort = "8243";
    private static final String gatewayHost = "localhost";
    private static final String serviceEndpoint = "https://localhost:9443/services/";
    private static final String getGatewayEndpoint = "https://localhost:8243";
    private static final String warFileName = "sample-data-backend";
    private static final String warFileLocation = System.getProperty("user.dir") + File.separator + "resources" + File.separator + "sample-data-backend.war";
    private static String clientTrustStore = System.getProperty("user.dir") + File.separator + ".." + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "client-truststore.jks";

    public static void main(String[] args) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException, IOException, org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiException, InterruptedException, UserAdminUserAdminException, ApiException {
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStore"))) {
            System.setProperty("javax.net.ssl.trustStore", clientTrustStore);
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStorePassword"))) {
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        }
        if (StringUtils.isEmpty((String)System.getProperty("javax.net.ssl.trustStoreType"))) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        System.out.println("Deploying sample back end");
        WebAppDeployUtils.deployWebApp((String)serviceEndpoint, (String)"admin", (String)"admin", (String)warFileLocation, (String)warFileName);
        String tenantDomain = "finance.abc.com";
        String tenantAdminUsername = "John";
        String tenantAdminPassword = "123123";
        try {
            System.out.println("Creating user tom");
            UserManagementUtils.addUser((String)"tom", (String)"123123", (String)serviceEndpoint, (String[])new String[]{"Internal/subscriber"}, (String)"admin", (String)"admin");
        }
        catch (RemoteException | UserAdminUserAdminException throwable) {
            // empty catch block
        }
        System.out.println("Creating tenant finance.abc.com");
        TenantUtils.createTenant((String)tenantAdminUsername, (String)tenantAdminPassword, (String)tenantDomain, (String)tenantAdminUsername, (String)"Smith", (String)serviceEndpoint);
        System.out.println("Creating advance policy 5KPerMin for finance.abc.com");
        ThrottlingUtils.addAdvanceThrottlePolicyForTenants((String)"5KPerMin", (String)"5KPerMin", (String)"Allows 5000 requests per minute", (String)"min", (Integer)1, (long)100000L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT, (long)0L, null, (String)tenantDomain, (String)tenantAdminUsername, (String)tenantAdminPassword);
        System.out.println("Creating advance policy 5KPerMin for super tenant");
        ThrottlingUtils.addAdvanceThrottlePolicy((String)"5KPerMin", (String)"5KPerMin", (String)"Allows 5000 requests per minute", (String)"min", (Integer)1, (long)100000L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT, (long)0L, null);
        System.out.println("Creating advance policy 100KPerMin for super tenant");
        ThrottlingUtils.addAdvanceThrottlePolicy((String)"100KPerMin", (String)"100KPerMin", (String)"Allows 100000 requests per minute", (String)"min", (Integer)1, (long)100000L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT, (long)0L, null);
        System.out.println("Creating advance policy 100KKBPerMin for super tenant");
        ThrottlingUtils.addAdvanceThrottlePolicy((String)"100KKBPerMin", (String)"100KKBPerMin", (String)"Allows 100000 kilo bytes per minute", (String)"min", (Integer)1, (long)0L, (ThrottleLimit.TypeEnum)ThrottleLimit.TypeEnum.BANDWIDTHLIMIT, (long)100000L, (String)"KB");
        System.out.println("Creating Salary_details_API API for finance.abc.com");
        String apiIdOne = SampleUtils.createApiForTenant((String)"Salary_details_API", (String)"1.0.0", (String)("/t/" + tenantDomain + "/salaries"), (API.VisibilityEnum)API.VisibilityEnum.PUBLIC, new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.CURRENT_TENANT, (String)"localhost", (String)port, new ArrayList(), (String)tenantDomain, (String)tenantAdminUsername, (String)tenantAdminPassword);
        System.out.println("Publishing Salary_details_API API for finance.abc.com");
        SampleUtils.publishAPI((String)apiIdOne, (String)tenantDomain, (String)tenantAdminUsername, (String)tenantAdminPassword);
        System.out.println("Creating Mobile_stock_API API for super tenant");
        String apiIdTwo = SampleUtils.createApi((String)"Mobile_stock_API", (String)"1.0.0", (String)"/stocks", new ArrayList(), new ArrayList(), (API.SubscriptionAvailabilityEnum)API.SubscriptionAvailabilityEnum.CURRENT_TENANT, (String)"localhost", (String)port, new ArrayList());
        System.out.println("Publishing Mobile_stock_API API for super tenant");
        SampleUtils.publishAPI((String)apiIdTwo);
        System.out.println("Waiting two seconds for API to be deployed to the gateway");
        Thread.sleep(2000L);
        System.out.println("Creating Application One");
        String applicationIdOne = SampleUtils.createApplication((String)"Application_one", (String)"This a new application created", (String)"Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("refresh_token");
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ArrayList<String> allowedDomain = new ArrayList<String>();
        allowedDomain.add("ALL");
        System.out.println("Generating keys for Application One");
        ApplicationKey applicationKey = SampleUtils.generateKeys((String)applicationIdOne, (String)"7200", null, (ApplicationKeyGenerateRequest.KeyTypeEnum)ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION, new ArrayList(), allowedDomain, grantTypes);
        String accessToken = applicationKey.getToken().getAccessToken();
        System.out.println("Creating a subscription for keys for Application One");
        SampleUtils.createSubscription((String)apiIdTwo, (String)applicationIdOne, (String)"Unlimited", (Subscription.StatusEnum)Subscription.StatusEnum.UNBLOCKED);
        HashMap<String, String> requestHeadersOne = new HashMap<String, String>();
        requestHeadersOne.put("Authorization", "Bearer " + accessToken);
        System.out.print("Invoking API using Application One to get analytics data");
        for (int i = 1; i <= 20; ++i) {
            HTTPSClientUtils.doGet((String)"https://localhost:8243/stocks/1.0.0/stock/1", requestHeadersOne);
            System.out.print(".");
        }
        System.out.println("");
        System.out.println("Creating a subscription for keys for Application Two");
        String applicationIdTwo = SampleUtils.createApplication((String)"Application_two", (String)"This a new application created", (String)"Unlimited");
        ApplicationKey applicationKeyTwo = SampleUtils.generateKeys((String)applicationIdTwo, (String)"7200", null, (ApplicationKeyGenerateRequest.KeyTypeEnum)ApplicationKeyGenerateRequest.KeyTypeEnum.PRODUCTION, new ArrayList(), allowedDomain, grantTypes);
        String accessTokenTwo = applicationKeyTwo.getToken().getAccessToken();
        System.out.println("Creating a subscription for keys for Application Two");
        SampleUtils.createSubscription((String)apiIdTwo, (String)applicationIdTwo, (String)"Unlimited", (Subscription.StatusEnum)Subscription.StatusEnum.UNBLOCKED);
        HashMap<String, String> requestHeadersTwo = new HashMap<String, String>();
        requestHeadersTwo.put("Authorization", "Bearer " + accessTokenTwo);
        System.out.print("Invoking API using Application Two to get analytics data");
        for (int i = 1; i <= 20; ++i) {
            HTTPSClientUtils.doGet((String)"https://localhost:8243/stocks/1.0.0/stock/1", requestHeadersTwo);
            System.out.print(".");
        }
    }
}

