/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils;

import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.axis2.client.Stub;
import org.wso2.carbon.apimgt.samples.utils.stubs.AuthenticateStub;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceStub;
import org.wso2.carbon.tenant.mgt.stub.beans.xsd.TenantInfoBean;

public class TenantUtils {
    public static boolean createTenant(String username, String password, String domainName, String firstName, String lastName, String backendUrl) {
        boolean isSuccess = false;
        try {
            String endPoint = backendUrl + "TenantMgtAdminService";
            TenantMgtAdminServiceStub tenantMgtAdminServiceStub = new TenantMgtAdminServiceStub(endPoint);
            AuthenticateStub.authenticateStub("admin", "admin", (Stub)tenantMgtAdminServiceStub);
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            TenantInfoBean tenantInfoBean = new TenantInfoBean();
            tenantInfoBean.setActive(true);
            tenantInfoBean.setEmail(username + "@" + domainName);
            tenantInfoBean.setAdminPassword(password);
            tenantInfoBean.setAdmin(username);
            tenantInfoBean.setTenantDomain(domainName);
            tenantInfoBean.setCreatedDate((Calendar)calendar);
            tenantInfoBean.setFirstname(firstName);
            tenantInfoBean.setLastname(lastName);
            tenantInfoBean.setSuccessKey("true");
            tenantInfoBean.setUsagePlan("demo");
            TenantInfoBean tenantInfoBeanGet = tenantMgtAdminServiceStub.getTenant(domainName);
            if (!tenantInfoBeanGet.getActive() && tenantInfoBeanGet.getTenantId() != 0) {
                tenantMgtAdminServiceStub.activateTenant(domainName);
                System.out.println("Tenant domain " + domainName + " activated successfully");
            } else if (!tenantInfoBeanGet.getActive()) {
                tenantMgtAdminServiceStub.addTenant(tenantInfoBean);
                tenantMgtAdminServiceStub.activateTenant(domainName);
                System.out.println("Tenant domain " + domainName + " created and activated successfully");
                isSuccess = true;
            } else {
                System.out.println("Tenant domain " + domainName + " already registered");
            }
        }
        catch (RemoteException e) {
            System.out.println("RemoteException thrown while adding user/tenants");
        }
        catch (TenantMgtAdminServiceExceptionException e) {
            System.out.println("Error connecting to the TenantMgtAdminService");
        }
        return isSuccess;
    }
}

