/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils.Clients;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.SampleUtils;
import org.wso2.carbon.apimgt.samples.utils.stubs.AuthenticateStub;
import org.wso2.carbon.governance.lcm.stub.LifeCycleManagementServiceExceptionException;
import org.wso2.carbon.governance.lcm.stub.LifeCycleManagementServiceStub;

public class LifecycleManagementClient {
    private final String serviceName = "LifeCycleManagementService";
    private LifeCycleManagementServiceStub lifeCycleManagementServiceStub;

    public LifecycleManagementClient(String backEndUrl, String username, String password) throws AxisFault {
        String endPoint = backEndUrl + "LifeCycleManagementService";
        this.lifeCycleManagementServiceStub = new LifeCycleManagementServiceStub(endPoint);
        AuthenticateStub.authenticateStub(username, password, (Stub)this.lifeCycleManagementServiceStub);
    }

    public void updateLifecycleConfiguration(String lifecycle) throws IOException, LifeCycleManagementServiceExceptionException {
        String configuration = this.getCustomLifecycleConfiguration(lifecycle);
        this.lifeCycleManagementServiceStub.updateLifecycle(lifecycle, configuration);
    }

    private String getCustomLifecycleConfiguration(String lifecycle) throws IOException {
        if (StringUtils.isNotEmpty((String)(lifecycle + ".xml"))) {
            return IOUtils.toString((InputStream)SampleUtils.class.getClassLoader().getResourceAsStream(lifecycle + ".xml"), (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }
}

