/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.api.APICollectionApi;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.api.APIIndividualApi;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.API;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.APIBusinessInformation;
import org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.model.APICorsConfiguration;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.api.ApplicationIndividualApi;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.api.SubscriptionIndividualApi;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.Application;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKey;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.ApplicationKeyGenerateRequest;
import org.wso2.carbon.apimgt.samples.utils.store.rest.client.model.Subscription;

public class SampleUtils {
    public static String createApi(String apiName, String version, String context, ArrayList<String> visibleRoles, ArrayList<String> visibleTenants, API.SubscriptionAvailabilityEnum subscriptionAvailabilityEnum, String hostname, String port, ArrayList<String> tags) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        API response;
        String endpointConfig;
        APICollectionApi api = new APICollectionApi();
        API body = new API();
        body.setName(apiName);
        body.setContext(context);
        body.setVersion(version);
        body.setVisibility(API.VisibilityEnum.PUBLIC);
        body.setDescription("This is the api description");
        body.setProvider("admin");
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("https");
            }
        });
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        body.setGatewayEnvironments("Production and Sandbox");
        body.setSubscriptionAvailability(subscriptionAvailabilityEnum);
        body.setVisibleRoles(visibleRoles);
        body.setSubscriptionAvailableTenants(visibleTenants);
        body.setSequences(new ArrayList());
        body.setBusinessInformation(new APIBusinessInformation());
        body.setCorsConfiguration(new APICorsConfiguration());
        body.setTags(tags);
        String filePrefix = context.substring(1);
        try {
            endpointConfig = SampleUtils.getJsonContent("endpoint-config-" + filePrefix + ".json");
        }
        catch (IOException e) {
            throw new org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException("Could not read End point definition");
        }
        body.setEndpointConfig(endpointConfig);
        try {
            body.setApiDefinition(SampleUtils.getJsonContent("api-definition-" + filePrefix + ".json"));
        }
        catch (IOException e) {
            throw new org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException("Could not read API definition file");
        }
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        body.setTiers(tierList);
        try {
            response = api.apisPost(body, "application/json");
        }
        catch (org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException e) {
            if (e.getResponseBody().contains("already exists")) {
                return null;
            }
            throw new org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException((Throwable)e);
        }
        return response.getId();
    }

    public static String createApiForTenant(String apiName, String version, String context, API.VisibilityEnum visibilityEnum, ArrayList<String> visibleRoles, ArrayList<String> visibleTenants, API.SubscriptionAvailabilityEnum subscriptionAvailabilityEnum, String hostname, String port, ArrayList<String> tags, String tenantDomain, String adminUsername, String adminPassword) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        API response;
        String endpointConfig;
        APICollectionApi api = new APICollectionApi();
        API body = new API();
        ApiClient apiClient = new ApiClient(tenantDomain, adminUsername, adminPassword);
        api.setApiClient(apiClient);
        body.setName(apiName);
        body.setContext(context);
        body.setVersion(version);
        body.setVisibility(visibilityEnum);
        body.setDescription("This is the api description");
        body.setProvider(adminUsername + "-AT-" + tenantDomain);
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("https");
            }
        });
        body.isDefaultVersion(Boolean.valueOf(false));
        body.setCacheTimeout(Integer.valueOf(100));
        body.setGatewayEnvironments("Production and Sandbox");
        body.setSubscriptionAvailability(subscriptionAvailabilityEnum);
        body.setVisibleRoles(visibleRoles);
        body.setSubscriptionAvailableTenants(visibleTenants);
        body.setSequences(new ArrayList());
        body.setBusinessInformation(new APIBusinessInformation());
        body.setCorsConfiguration(new APICorsConfiguration());
        body.setTags(tags);
        String[] splitData = context.split("/");
        String filePrefix = splitData[splitData.length - 1];
        try {
            endpointConfig = SampleUtils.getJsonContent("endpoint-config-" + filePrefix + ".json");
        }
        catch (IOException e) {
            throw new org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException("Could not read End point definition");
        }
        body.setEndpointConfig(endpointConfig);
        try {
            body.setApiDefinition(SampleUtils.getJsonContent("api-definition-" + filePrefix + ".json"));
        }
        catch (IOException e) {
            throw new org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException("Could not read API definition file");
        }
        ArrayList<String> tierList = new ArrayList<String>();
        tierList.add("Unlimited");
        body.setTiers(tierList);
        try {
            response = api.apisPost(body, "application/json");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return response.getId();
    }

    public static String createNewAPIVersion(String newVersion, String apiId) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        APIIndividualApi api = new APIIndividualApi();
        String apiLocation = (String)((List)api.apisCopyApiPostWithHttpInfo(newVersion, apiId).getHeaders().get("Location")).get(0);
        String[] splitValues = apiLocation.split("/");
        return splitValues[splitValues.length - 1];
    }

    private static String getJsonContent(String fileName) throws IOException {
        if (StringUtils.isNotEmpty((String)fileName)) {
            return IOUtils.toString((InputStream)SampleUtils.class.getClassLoader().getResourceAsStream(fileName), (String)StandardCharsets.UTF_8.name());
        }
        return null;
    }

    public static void publishAPI(String apiId) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        APIIndividualApi apiIndividualApi = new APIIndividualApi();
        apiIndividualApi.apisChangeLifecyclePost("Publish", apiId, null, null, null);
    }

    public static void deprecateAPI(String apiId) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        APIIndividualApi apiIndividualApi = new APIIndividualApi();
        apiIndividualApi.apisChangeLifecyclePost("Deprecate", apiId, null, null, null);
    }

    public static void blockAPI(String apiId) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        APIIndividualApi apiIndividualApi = new APIIndividualApi();
        apiIndividualApi.apisChangeLifecyclePost("Block", apiId, null, null, null);
    }

    public static void rejectAPI(String apiId) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        APIIndividualApi apiIndividualApi = new APIIndividualApi();
        apiIndividualApi.apisChangeLifecyclePost("Reject", apiId, null, null, null);
    }

    public static void publishAPI(String apiId, String tenantDomain, String adminUsername, String adminPassword) throws org.wso2.carbon.apimgt.samples.utils.publisher.rest.client.ApiException {
        APIIndividualApi apiIndividualApi = new APIIndividualApi();
        ApiClient apiClient = new ApiClient(tenantDomain, adminUsername, adminPassword);
        apiIndividualApi.setApiClient(apiClient);
        apiIndividualApi.apisChangeLifecyclePost("Publish", apiId, null, null, null);
    }

    public static String createApplication(String appName, String description, String throttleTier) {
        try {
            Application application = new Application();
            application.setName(appName);
            application.setDescription(description);
            application.setThrottlingTier(throttleTier);
            ApplicationIndividualApi applicationIndividualApi = new ApplicationIndividualApi();
            Application createdApp = applicationIndividualApi.applicationsPost(application, "application/json");
            return createdApp.getApplicationId();
        }
        catch (ApiException apiException) {
            return null;
        }
    }

    public static String createSubscription(String apiId, String applicationId, String subscriptionTier, Subscription.StatusEnum statusEnum) throws ApiException {
        Subscription subscription = new Subscription();
        subscription.setApplicationId(applicationId);
        subscription.setApiIdentifier(apiId);
        subscription.setTier(subscriptionTier);
        subscription.setStatus(statusEnum);
        SubscriptionIndividualApi subscriptionIndividualApi = new SubscriptionIndividualApi();
        return subscriptionIndividualApi.subscriptionsPost(subscription, "application/json").getSubscriptionId();
    }

    public static ApplicationKey generateKeys(String applicationId, String validityTime, String callBackUrl, ApplicationKeyGenerateRequest.KeyTypeEnum keyTypeEnum, ArrayList<String> scopes, ArrayList<String> allowDomains, ArrayList<String> grantTypes) throws ApiException {
        ApplicationKeyGenerateRequest applicationKeyGenerateRequest = new ApplicationKeyGenerateRequest();
        applicationKeyGenerateRequest.setValidityTime(validityTime);
        applicationKeyGenerateRequest.setCallbackUrl(callBackUrl);
        applicationKeyGenerateRequest.setKeyType(keyTypeEnum);
        applicationKeyGenerateRequest.setScopes(scopes);
        applicationKeyGenerateRequest.setAccessAllowDomains(allowDomains);
        applicationKeyGenerateRequest.setSupportedGrantTypes(grantTypes);
        ApplicationIndividualApi applicationIndividualApi = new ApplicationIndividualApi();
        return applicationIndividualApi.applicationsGenerateKeysPost(applicationId, applicationKeyGenerateRequest, "application/json", null, null);
    }
}

