/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.samples.utils;

import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiClient;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.ApiException;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.api.AdvancedPolicyCollectionApi;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.AdvancedThrottlePolicy;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.BandwidthLimit;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ConditionalGroup;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.HeaderCondition;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.IPCondition;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.RequestCountLimit;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleCondition;
import org.wso2.carbon.apimgt.samples.utils.admin.rest.client.model.ThrottleLimit;

public class ThrottlingUtils {
    public static String addAdvanceThrottlePolicy(String displayName, String policyName, String description, String timeUnit, Integer unitTime, long requestCount, ThrottleLimit.TypeEnum typeEnum, long dataAmount, String dataUnit) throws ApiException {
        AdvancedThrottlePolicy advancedThrottlePolicy = ThrottlingUtils.createThrottlePolicyObject(displayName, policyName, description, timeUnit, unitTime, requestCount, typeEnum, dataAmount, dataUnit);
        AdvancedPolicyCollectionApi advancedPolicyCollectionApi = new AdvancedPolicyCollectionApi();
        AdvancedThrottlePolicy result = advancedPolicyCollectionApi.throttlingPoliciesAdvancedPost(advancedThrottlePolicy, "application/json");
        return result.getPolicyId();
    }

    public static String addAdvanceThrottlePolicyForTenants(String displayName, String policyName, String description, String timeUnit, Integer unitTime, long requestCount, ThrottleLimit.TypeEnum typeEnum, long dataAmount, String dataUnit, String tenantDomain, String adminUsername, String adminPassword) throws ApiException {
        AdvancedThrottlePolicy advancedThrottlePolicy = ThrottlingUtils.createThrottlePolicyObject(displayName, policyName, description, timeUnit, unitTime, requestCount, typeEnum, dataAmount, dataUnit);
        ApiClient apiClient = new ApiClient(tenantDomain, adminUsername, adminPassword);
        AdvancedPolicyCollectionApi advancedPolicyCollectionApi = new AdvancedPolicyCollectionApi();
        advancedPolicyCollectionApi.setApiClient(apiClient);
        AdvancedThrottlePolicy result = advancedPolicyCollectionApi.throttlingPoliciesAdvancedPost(advancedThrottlePolicy, "application/json");
        return result.getPolicyId();
    }

    public static String addAdvanceThrottlePolicyWithConditionalGroups(String displayName, String policyName, String description, String timeUnit, Integer unitTime, long requestCount, ThrottleLimit.TypeEnum typeEnum, long dataAmount, String dataUnit, String startingIP, String endingIP, String headerName, String headerValue, boolean invertHeaderCondition, String conditionalGroupDescription) throws ApiException {
        AdvancedThrottlePolicy advancedThrottlePolicy = ThrottlingUtils.createThrottlePolicyObjectWithConditionalGroups(displayName, policyName, description, timeUnit, unitTime, requestCount, typeEnum, dataAmount, dataUnit, startingIP, endingIP, headerName, headerValue, invertHeaderCondition, conditionalGroupDescription);
        AdvancedPolicyCollectionApi advancedPolicyCollectionApi = new AdvancedPolicyCollectionApi();
        AdvancedThrottlePolicy result = advancedPolicyCollectionApi.throttlingPoliciesAdvancedPost(advancedThrottlePolicy, "application/json");
        return result.getPolicyId();
    }

    private static AdvancedThrottlePolicy createThrottlePolicyObject(String displayName, String policyName, String description, String timeUnit, Integer unitTime, long requestCount, ThrottleLimit.TypeEnum typeEnum, long dataAmount, String dataUnit) {
        AdvancedThrottlePolicy advancedThrottlePolicy = new AdvancedThrottlePolicy();
        advancedThrottlePolicy.displayName(displayName);
        advancedThrottlePolicy.setPolicyName(policyName);
        advancedThrottlePolicy.setDescription(description);
        if (ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT.equals((Object)typeEnum)) {
            RequestCountLimit requestCountLimit = new RequestCountLimit();
            requestCountLimit.setType(ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT);
            requestCountLimit.setTimeUnit(timeUnit);
            requestCountLimit.setUnitTime(unitTime);
            requestCountLimit.requestCount(Long.valueOf(requestCount));
            advancedThrottlePolicy.setDefaultLimit((ThrottleLimit)requestCountLimit);
        } else if (ThrottleLimit.TypeEnum.BANDWIDTHLIMIT.equals((Object)typeEnum)) {
            BandwidthLimit bandwidthLimit = new BandwidthLimit();
            bandwidthLimit.setDataAmount(Long.valueOf(dataAmount));
            bandwidthLimit.setDataUnit(dataUnit);
            bandwidthLimit.setTimeUnit(timeUnit);
            bandwidthLimit.setUnitTime(unitTime);
            bandwidthLimit.setType(ThrottleLimit.TypeEnum.BANDWIDTHLIMIT);
            advancedThrottlePolicy.setDefaultLimit((ThrottleLimit)bandwidthLimit);
        } else {
            return null;
        }
        return advancedThrottlePolicy;
    }

    private static AdvancedThrottlePolicy createThrottlePolicyObjectWithConditionalGroups(String displayName, String policyName, String description, String timeUnit, Integer unitTime, long requestCount, ThrottleLimit.TypeEnum typeEnum, long dataAmount, String dataUnit, String startingIP, String endingIP, String headerName, String headerValue, boolean invertHeaderCondition, String conditionalGroupDescription) {
        AdvancedThrottlePolicy advancedThrottlePolicy = ThrottlingUtils.createThrottlePolicyObject(displayName, policyName, description, timeUnit, unitTime, requestCount, typeEnum, dataAmount, dataUnit);
        IPCondition ipCondition = new IPCondition();
        ipCondition.setIpConditionType(IPCondition.IpConditionTypeEnum.IPRANGE);
        ipCondition.setStartingIP(startingIP);
        ipCondition.setEndingIP(endingIP);
        ipCondition.setType(ThrottleCondition.TypeEnum.IPCONDITION);
        HeaderCondition headerCondition = new HeaderCondition();
        headerCondition.setType(ThrottleCondition.TypeEnum.HEADERCONDITION);
        headerCondition.setHeaderName(headerName);
        headerCondition.setHeaderValue(headerValue);
        headerCondition.invertCondition(Boolean.valueOf(invertHeaderCondition));
        ConditionalGroup conditionalGroup = new ConditionalGroup();
        conditionalGroup.setDescription(conditionalGroupDescription);
        conditionalGroup.addConditionsItem((ThrottleCondition)ipCondition);
        conditionalGroup.addConditionsItem((ThrottleCondition)headerCondition);
        if (ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT.equals((Object)typeEnum)) {
            RequestCountLimit requestCountLimit = new RequestCountLimit();
            requestCountLimit.setType(ThrottleLimit.TypeEnum.REQUESTCOUNTLIMIT);
            requestCountLimit.setTimeUnit(timeUnit);
            requestCountLimit.setUnitTime(unitTime);
            requestCountLimit.requestCount(Long.valueOf(requestCount));
            conditionalGroup.setLimit((ThrottleLimit)requestCountLimit);
        } else if (ThrottleLimit.TypeEnum.BANDWIDTHLIMIT.equals((Object)typeEnum)) {
            BandwidthLimit bandwidthLimit = new BandwidthLimit();
            bandwidthLimit.setDataAmount(Long.valueOf(dataAmount));
            bandwidthLimit.setDataUnit(dataUnit);
            bandwidthLimit.setTimeUnit(timeUnit);
            bandwidthLimit.setUnitTime(unitTime);
            bandwidthLimit.setType(ThrottleLimit.TypeEnum.BANDWIDTHLIMIT);
            conditionalGroup.setLimit((ThrottleLimit)bandwidthLimit);
        }
        advancedThrottlePolicy.addConditionalGroupsItem(conditionalGroup);
        return advancedThrottlePolicy;
    }
}

