/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.jms.JMSException;
import javax.jms.XASession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQConnectionDelegate;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.AMQSession_0_8;
import org.wso2.andes.client.ConnectionTuneParameters;
import org.wso2.andes.client.JMSAMQException;
import org.wso2.andes.client.SSLConfiguration;
import org.wso2.andes.client.failover.FailoverException;
import org.wso2.andes.client.failover.FailoverProtectedOperation;
import org.wso2.andes.client.failover.FailoverRetrySupport;
import org.wso2.andes.client.state.AMQState;
import org.wso2.andes.client.state.StateWaiter;
import org.wso2.andes.framing.BasicQosBody;
import org.wso2.andes.framing.BasicQosOkBody;
import org.wso2.andes.framing.ChannelOpenBody;
import org.wso2.andes.framing.ChannelOpenOkBody;
import org.wso2.andes.framing.ProtocolVersion;
import org.wso2.andes.framing.TxSelectBody;
import org.wso2.andes.framing.TxSelectOkBody;
import org.wso2.andes.jms.BrokerDetails;
import org.wso2.andes.jms.ChannelLimitReachedException;
import org.wso2.andes.jms.Session;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.network.NetworkConnection;
import org.wso2.andes.transport.network.OutgoingNetworkTransport;
import org.wso2.andes.transport.network.Transport;

public class AMQConnectionDelegate_8_0
implements AMQConnectionDelegate {
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnectionDelegate_8_0.class);
    private AMQConnection _conn;
    private Connection qpidConnection;

    @Override
    public void closeConnection(long timeout) throws JMSException, AMQException {
        this._conn.getProtocolHandler().closeConnection(timeout);
    }

    public AMQConnectionDelegate_8_0(AMQConnection conn) {
        this._conn = conn;
    }

    protected boolean checkException(Throwable thrown) {
        Throwable cause = thrown.getCause();
        if (cause == null) {
            cause = thrown;
        }
        return cause instanceof ConnectException || cause instanceof UnresolvedAddressException;
    }

    @Override
    public ProtocolVersion makeBrokerConnection(BrokerDetails brokerDetail) throws AMQException, IOException {
        AMQState state;
        block7: {
            EnumSet<AMQState> openOrClosedStates = EnumSet.of(AMQState.CONNECTION_OPEN, AMQState.CONNECTION_CLOSED);
            StateWaiter waiter = this._conn._protocolHandler.createWaiter(openOrClosedStates);
            SSLConfiguration sslConfig = null;
            ConnectionSettings settings = new ConnectionSettings();
            settings.setHost(brokerDetail.getHost());
            settings.setPort(brokerDetail.getPort());
            settings.setProtocol(brokerDetail.getTransport());
            boolean sslEnabled = Boolean.parseBoolean(brokerDetail.getProperty("ssl"));
            if (sslEnabled) {
                sslConfig = new SSLConfiguration();
                sslConfig.setKeystorePath(brokerDetail.getProperty("key_store"));
                sslConfig.setKeystorePassword(brokerDetail.getProperty("key_store_password"));
                sslConfig.setTrustStorePath(brokerDetail.getProperty("trust_store"));
                sslConfig.setTrustStorePassword(brokerDetail.getProperty("trust_store_password"));
                sslConfig.setSslCertAlias(brokerDetail.getProperty("ssl_cert_alias"));
            }
            if (sslConfig != null) {
                settings.setTrustStorePath(sslConfig.getTrustStorePath());
                settings.setTrustStorePassword(sslConfig.getTrustStorePassword());
                settings.setKeyStorePath(sslConfig.getKeystorePath());
                settings.setKeyStorePassword(sslConfig.getKeystorePassword());
                settings.setUseSSL(Boolean.parseBoolean("true"));
                settings.setCertAlias(sslConfig.getSslCertAlias());
                settings.setKeyStoreCertType(sslConfig.getKeyStoreCertType());
                settings.setTrustStoreCertType(sslConfig.getTrustStoreCertType());
                if (settings.getKeyStorePath() == null && settings.getKeyStorePassword() == null && settings.getTrustStorePath() == null && settings.getTrustStorePassword() == null) {
                    _logger.warn("Loading keystore and truststore from system properties");
                    settings.loadSSLConfigFromSysConfig();
                }
                if (settings.getKeyStorePath() == null || settings.getKeyStorePassword() == null) {
                    settings.setKeyStorePath(sslConfig.getTrustStorePath());
                    settings.setKeyStorePassword(sslConfig.getTrustStorePassword());
                }
            }
            state = null;
            NetworkConnection network = null;
            try {
                OutgoingNetworkTransport transport = Transport.getOutgoingTransportInstance(this.getProtocolVersion());
                network = transport.connect(settings, this._conn._protocolHandler, null);
                this._conn._protocolHandler.setNetworkConnection(network);
                this._conn._protocolHandler.getProtocolSession().init();
                state = waiter.await();
            }
            catch (Exception e) {
                if (null == network) break block7;
                network.close();
            }
        }
        if (state == AMQState.CONNECTION_OPEN) {
            this._conn._failoverPolicy.attainedConnection();
            this._conn._connected = true;
            return null;
        }
        return this._conn._protocolHandler.getSuggestedProtocolVersion();
    }

    public Session createSession(boolean transacted, int acknowledgeMode, int prefetch) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, prefetch, prefetch);
    }

    @Override
    public XASession createXASession(int prefetchHigh, int prefetchLow) throws JMSException {
        throw new UnsupportedOperationException("0_8 version does not provide XA support");
    }

    @Override
    public Session createSession(final boolean transacted, final int acknowledgeMode, final int prefetchHigh, final int prefetchLow) throws JMSException {
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        return new FailoverRetrySupport<Session, JMSException>(new FailoverProtectedOperation<Session, JMSException>(){

            @Override
            public Session execute() throws JMSException, FailoverException {
                int channelId = AMQConnectionDelegate_8_0.this._conn.getNextChannelID();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Write channel open frame for channel id " + channelId);
                }
                AMQSession_0_8 session = new AMQSession_0_8(AMQConnectionDelegate_8_0.this._conn, channelId, transacted, acknowledgeMode, prefetchHigh, prefetchLow);
                AMQConnectionDelegate_8_0.this._conn.registerSession(channelId, session);
                boolean success = false;
                try {
                    AMQConnectionDelegate_8_0.this.createChannelOverWire(channelId, prefetchHigh, prefetchLow, transacted);
                    success = true;
                }
                catch (AMQException e) {
                    JMSException jmse = new JMSException("Error creating session: " + e);
                    jmse.setLinkedException((Exception)e);
                    jmse.initCause((Throwable)e);
                    throw jmse;
                }
                finally {
                    if (!success) {
                        AMQConnectionDelegate_8_0.this._conn.deregisterSession(channelId);
                    }
                }
                if (((AMQConnectionDelegate_8_0)AMQConnectionDelegate_8_0.this)._conn._started) {
                    try {
                        session.start();
                    }
                    catch (AMQException e) {
                        throw new JMSAMQException(e);
                    }
                }
                return session;
            }
        }, this._conn).execute();
    }

    @Override
    public XASession createXASession() throws JMSException {
        return this.createXASession((int)this._conn.getMaxPrefetch(), (int)this._conn.getMaxPrefetch() / 2);
    }

    private void createChannelOverWire(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws AMQException, FailoverException {
        ChannelOpenBody channelOpenBody = this._conn.getProtocolHandler().getMethodRegistry().createChannelOpenBody(null);
        this._conn._protocolHandler.syncWrite(channelOpenBody.generateFrame(channelId), ChannelOpenOkBody.class);
        BasicQosBody basicQosBody = this._conn.getProtocolHandler().getMethodRegistry().createBasicQosBody(0L, prefetchHigh, false);
        this._conn._protocolHandler.syncWrite(basicQosBody.generateFrame(channelId), BasicQosOkBody.class);
        if (transacted) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Issuing TxSelect for " + channelId);
            }
            TxSelectBody body = this._conn.getProtocolHandler().getMethodRegistry().createTxSelectBody();
            this._conn._protocolHandler.syncWrite(body.generateFrame(channelId), TxSelectOkBody.class);
        }
    }

    @Override
    public void failoverPrep() {
    }

    @Override
    public void resubscribeSessions() throws JMSException, AMQException, FailoverException {
        ArrayList<AMQSession> sessions = new ArrayList<AMQSession>(this._conn.getSessions().values());
        if (_logger.isDebugEnabled()) {
            _logger.debug(MessageFormat.format("Resubscribing sessions = {0} sessions.size={1}", sessions, sessions.size()));
        }
        for (AMQSession s : sessions) {
            this.reopenChannel(s.getChannelId(), s.getDefaultPrefetchHigh(), s.getDefaultPrefetchLow(), s.getTransacted());
            s.resubscribe();
            if (s.getTransacted()) continue;
            s.recover();
        }
    }

    private void reopenChannel(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws AMQException, FailoverException {
        try {
            this.createChannelOverWire(channelId, prefetchHigh, prefetchLow, transacted);
        }
        catch (AMQException e) {
            this._conn.deregisterSession(channelId);
            throw new AMQException(null, "Error reopening channel " + channelId + " after failover: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T executeRetrySupport(FailoverProtectedOperation<T, E> operation) throws E {
        while (true) {
            try {
                this._conn.blockUntilNotFailingOver();
            }
            catch (InterruptedException e) {
                _logger.debug("Interrupted: " + e, (Throwable)e);
                return null;
            }
            Object object = this._conn.getFailoverMutex();
            synchronized (object) {
                block9: {
                    try {
                        return operation.execute();
                    }
                    catch (FailoverException e) {
                        _logger.debug("Failover exception caught during operation: " + e, (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        if (e.getMessage().startsWith("Fail-over interupted no-op failover support")) break block9;
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public int getMaxChannelID() {
        ConnectionTuneParameters params = this._conn.getProtocolHandler().getProtocolSession().getConnectionTuneParameters();
        return params == null ? 65535 : params.getChannelMax();
    }

    @Override
    public int getMinChannelID() {
        return 1;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.v8_0;
    }

    @Override
    public void verifyClientID() throws JMSException {
    }
}

