/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.XASession_0_10;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.transport.DtxXaStatus;
import org.wso2.andes.transport.ExecutionErrorCode;
import org.wso2.andes.transport.Future;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.RecoverResult;
import org.wso2.andes.transport.SessionException;
import org.wso2.andes.transport.XaResult;
import org.wso2.andes.transport.Xid;

public class XAResource_0_10
implements XAResource {
    private static final Logger _logger = LoggerFactory.getLogger(XAResource_0_10.class);
    private XASession_0_10 _xaSession = null;
    private javax.transaction.xa.Xid _xid;
    private int _timeout;

    protected XAResource_0_10(XASession_0_10 xaSession) {
        this._xaSession = xaSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(javax.transaction.xa.Xid xid, boolean b) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("commit tx branch with xid:  ", (Object)xid);
        }
        Future<XaResult> future = this._xaSession.getQpidSession().dtxCommit(this.convertXid(xid), b ? Option.ONE_PHASE : Option.NONE);
        XaResult result = null;
        try {
            result = future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        finally {
            this._xid = null;
        }
        this.checkStatus(result.getStatus());
    }

    @Override
    public void end(javax.transaction.xa.Xid xid, int flag) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("end tx branch with xid: ", (Object)xid);
        }
        switch (flag) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                break;
            }
            case 0x2000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this._xaSession.flushAcknowledgments();
        Future<XaResult> future = this._xaSession.getQpidSession().dtxEnd(this.convertXid(xid), flag == 0x20000000 ? Option.FAIL : Option.NONE, flag == 0x2000000 ? Option.SUSPEND : Option.NONE);
        XaResult result = null;
        try {
            result = future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        this.checkStatus(result.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(javax.transaction.xa.Xid xid) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("forget tx branch with xid: ", (Object)xid);
        }
        this._xaSession.getQpidSession().dtxForget(this.convertXid(xid), new Option[0]);
        try {
            this._xaSession.getQpidSession().sync();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        finally {
            this._xid = null;
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this._timeout;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        return false;
    }

    @Override
    public int prepare(javax.transaction.xa.Xid xid) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("prepare ", (Object)xid);
        }
        Future<XaResult> future = this._xaSession.getQpidSession().dtxPrepare(this.convertXid(xid), new Option[0]);
        XaResult result = null;
        try {
            result = future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        DtxXaStatus status = result.getStatus();
        int outcome = 0;
        switch (status) {
            case XA_OK: {
                break;
            }
            case XA_RDONLY: {
                outcome = 3;
                break;
            }
            default: {
                this.checkStatus(status);
            }
        }
        return outcome;
    }

    @Override
    public javax.transaction.xa.Xid[] recover(int flag) throws XAException {
        Future<RecoverResult> future = this._xaSession.getQpidSession().dtxRecover(new Option[0]);
        RecoverResult res = null;
        try {
            res = future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        javax.transaction.xa.Xid[] result = new javax.transaction.xa.Xid[res.getInDoubt().size()];
        int i = 0;
        for (Object obj : res.getInDoubt()) {
            Xid xid = (Xid)obj;
            result[i] = new XidImpl(xid.getBranchId(), (int)xid.getFormat(), xid.getGlobalId());
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(javax.transaction.xa.Xid xid) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("rollback tx branch with xid: ", (Object)xid);
        }
        Future<XaResult> future = this._xaSession.getQpidSession().dtxRollback(this.convertXid(xid), new Option[0]);
        XaResult result = null;
        try {
            result = future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        finally {
            this._xid = null;
        }
        this.checkStatus(result.getStatus());
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this._timeout = timeout;
        if (timeout != this._timeout && this._xid != null) {
            this.setDtxTimeout(this._timeout);
        }
        return true;
    }

    private void setDtxTimeout(int timeout) throws XAException {
        this._xaSession.getQpidSession().dtxSetTimeout(XidImpl.convert(this._xid), timeout, new Option[0]);
    }

    @Override
    public void start(javax.transaction.xa.Xid xid, int flag) throws XAException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("start tx branch with xid: ", (Object)xid);
        }
        switch (flag) {
            case 0: {
                break;
            }
            case 0x200000: {
                break;
            }
            case 0x8000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        Future<XaResult> future = this._xaSession.getQpidSession().dtxStart(this.convertXid(xid), flag == 0x200000 ? Option.JOIN : Option.NONE, flag == 0x8000000 ? Option.RESUME : Option.NONE);
        XaResult result = null;
        try {
            result = future.get();
        }
        catch (SessionException e) {
            this._xaSession.createSession();
            this.convertExecutionErrorToXAErr(e.getException().getErrorCode());
        }
        this.checkStatus(result.getStatus());
        this._xid = xid;
        if (this._timeout > 0) {
            this.setDtxTimeout(this._timeout);
        }
    }

    private void checkStatus(DtxXaStatus status) throws XAException {
        switch (status) {
            case XA_OK: {
                break;
            }
            case XA_RBROLLBACK: {
                throw new XAException(100);
            }
            case XA_RBTIMEOUT: {
                throw new XAException(106);
            }
            case XA_HEURHAZ: {
                throw new XAException(8);
            }
            case XA_HEURCOM: {
                throw new XAException(7);
            }
            case XA_HEURRB: {
                throw new XAException(6);
            }
            case XA_HEURMIX: {
                throw new XAException(5);
            }
            case XA_RDONLY: {
                throw new XAException(3);
            }
            default: {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("got unexpected status value: ", (Object)status);
                }
                throw new XAException(-3);
            }
        }
    }

    private void convertExecutionErrorToXAErr(ExecutionErrorCode error) throws XAException {
        switch (error) {
            case NOT_ALLOWED: {
                throw new XAException(-8);
            }
            case NOT_FOUND: {
                try {
                    throw new XAException(-4);
                }
                catch (XAException e) {
                    _logger.error("XA Error ", (Throwable)e);
                    throw e;
                }
            }
            case ILLEGAL_STATE: {
                throw new XAException(-6);
            }
            case NOT_IMPLEMENTED: {
                throw new XAException(-3);
            }
            case COMMAND_INVALID: {
                throw new XAException(-5);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Got unexpected error: " + (Object)((Object)error));
        }
        throw new XAException(-3);
    }

    private Xid convertXid(javax.transaction.xa.Xid xid) throws XAException {
        if (xid == null) {
            throw new XAException(-5);
        }
        return XidImpl.convert(xid);
    }
}

