/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.XaJmsSession;
import org.wso2.andes.client.AMQConnection;
import org.wso2.andes.client.AMQSession_0_8;
import org.wso2.andes.client.XAResource_0_9_1;
import org.wso2.andes.client.failover.FailoverException;
import org.wso2.andes.framing.BasicQosBody;
import org.wso2.andes.framing.BasicQosOkBody;
import org.wso2.andes.framing.ChannelOpenBody;
import org.wso2.andes.framing.ChannelOpenOkBody;
import org.wso2.andes.framing.DtxCommitBody;
import org.wso2.andes.framing.DtxCommitOkBody;
import org.wso2.andes.framing.DtxEndBody;
import org.wso2.andes.framing.DtxEndOkBody;
import org.wso2.andes.framing.DtxForgetBody;
import org.wso2.andes.framing.DtxForgetOkBody;
import org.wso2.andes.framing.DtxPrepareBody;
import org.wso2.andes.framing.DtxPrepareOkBody;
import org.wso2.andes.framing.DtxRecoverBody;
import org.wso2.andes.framing.DtxRecoverOkBody;
import org.wso2.andes.framing.DtxRollbackBody;
import org.wso2.andes.framing.DtxRollbackOkBody;
import org.wso2.andes.framing.DtxSelectBody;
import org.wso2.andes.framing.DtxSetTimeoutBody;
import org.wso2.andes.framing.DtxSetTimeoutOkBody;
import org.wso2.andes.framing.DtxStartBody;
import org.wso2.andes.framing.DtxStartOkBody;
import org.wso2.andes.framing.amqp_0_91.DtxCommitOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxEndOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxForgetOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxPrepareOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxRecoverOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxRollbackOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxSetTimeoutOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.DtxStartOkBodyImpl;
import org.wso2.andes.framing.amqp_0_91.MethodRegistry_0_91;
import org.wso2.andes.protocol.AMQMethodEvent;
import org.wso2.andes.transport.XaStatus;

public class XASession_9_1
extends AMQSession_0_8
implements XASession,
XAQueueSession,
XATopicSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(XASession_9_1.class);
    private final MethodRegistry_0_91 methodRegistry;
    private final XAResource_0_9_1 xaResource;

    XASession_9_1(AMQConnection con, int channelId, int defaultPrefetchHigh, int defaultPrefetchLow) throws FailoverException, AMQException {
        super(con, channelId, false, 1, defaultPrefetchHigh, defaultPrefetchLow);
        this.methodRegistry = (MethodRegistry_0_91)con.getProtocolHandler().getMethodRegistry();
        con.registerSession(channelId, this);
        try {
            this.createChannelOverWire(con, channelId, defaultPrefetchHigh);
        }
        catch (AMQException | FailoverException e) {
            con.deregisterSession(channelId);
            throw e;
        }
        this.xaResource = new XAResource_0_9_1(this);
    }

    private void createChannelOverWire(AMQConnection connection, int channelId, int prefetchHigh) throws FailoverException, AMQException {
        ChannelOpenBody channelOpenBody = this.methodRegistry.createChannelOpenBody(null);
        connection._protocolHandler.syncWrite(channelOpenBody.generateFrame(channelId), ChannelOpenOkBody.class);
        BasicQosBody basicQosBody = this.methodRegistry.createBasicQosBody(0L, prefetchHigh, false);
        connection._protocolHandler.syncWrite(basicQosBody.generateFrame(channelId), BasicQosOkBody.class);
        DtxSelectBody body = this.methodRegistry.createDtxSelectBody();
        connection._protocolHandler.writeFrame(body.generateFrame(channelId));
    }

    public Session getSession() throws JMSException {
        return new XaJmsSession(this);
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }

    XaStatus startDtx(Xid xid, int flag) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxStartBody dtxStartBody = this.methodRegistry.createDtxStartBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), flag == 0x200000, flag == 0x8000000);
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxStartBody.generateFrame(this._channelId), DtxStartOkBody.class);
        DtxStartOkBodyImpl response = (DtxStartOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public XaStatus endDtx(Xid xid, int flag) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending dtx.end for channel " + this._channelId + ", xid " + xid);
        }
        DtxEndBody dtxEndBody = this.methodRegistry.createDtxEndBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), flag == 0x20000000, flag == 0x2000000);
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxEndBody.generateFrame(this._channelId), DtxEndOkBody.class);
        DtxEndOkBodyImpl response = (DtxEndOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public XaStatus prepareDtx(Xid xid) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxPrepareBody dtxPrepareBody = this.methodRegistry.createDtxPrepareBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxPrepareBody.generateFrame(this._channelId), DtxPrepareOkBody.class);
        DtxPrepareOkBodyImpl response = (DtxPrepareOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public XaStatus commitDtx(Xid xid, boolean onePhase) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxCommitBody dtxCommitBody = this.methodRegistry.createDtxCommitBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), onePhase);
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxCommitBody.generateFrame(this._channelId), DtxCommitOkBody.class);
        DtxCommitOkBodyImpl response = (DtxCommitOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public XaStatus rollbackDtx(Xid xid) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxRollbackBody dtxRollbackBody = this.methodRegistry.createDtxRollbackBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxRollbackBody.generateFrame(this._channelId), DtxRollbackOkBody.class);
        DtxRollbackOkBodyImpl response = (DtxRollbackOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public XaStatus forget(Xid xid) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxForgetBody dtxForgetBody = this.methodRegistry.createDtxForgetBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxForgetBody.generateFrame(this._channelId), DtxForgetOkBody.class);
        DtxForgetOkBodyImpl response = (DtxForgetOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public XaStatus setDtxTimeout(Xid xid, int timeout) throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxSetTimeoutBody dtxSetTimeoutBody = this.methodRegistry.createDtxSetTimeoutBody(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier(), timeout);
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxSetTimeoutBody.generateFrame(this._channelId), DtxSetTimeoutOkBody.class);
        DtxSetTimeoutOkBodyImpl response = (DtxSetTimeoutOkBodyImpl)amqMethodEvent.getMethod();
        return XaStatus.valueOf(response.getXaResult());
    }

    public List<Xid> recoverDtxTransactions() throws FailoverException, AMQException, XAException {
        this.throwErrorIfClosed();
        DtxRecoverBody dtxRecoverBody = this.methodRegistry.createDtxRecoverBody();
        AMQMethodEvent amqMethodEvent = this._connection._protocolHandler.syncWrite(dtxRecoverBody.generateFrame(this._channelId), DtxRecoverOkBody.class);
        DtxRecoverOkBodyImpl response = (DtxRecoverOkBodyImpl)amqMethodEvent.getMethod();
        byte[] inDoubtRawData = response.getInDoubt();
        ArrayList xidList = (ArrayList)SerializationUtils.deserialize(inDoubtRawData);
        return xidList;
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    private void throwErrorIfClosed() throws XAException {
        if (this.isClosed()) {
            XAException xaException = new XAException("Session is already closed");
            xaException.errorCode = 101;
            throw xaException;
        }
    }

    @Override
    public void commit() throws JMSException {
        throw new TransactionInProgressException("XASession:  A direct invocation of the commit operation is prohibited!");
    }

    @Override
    public void rollback() throws JMSException {
        throw new TransactionInProgressException("XASession: A direct invocation of the rollback operation is prohibited!");
    }

    @Override
    public void recover() throws JMSException {
        throw new TransactionInProgressException("XASession: A direct invocation of the recover operation is prohibited!");
    }
}

