/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.ConnectionTuneParameters;
import org.wso2.andes.client.protocol.AMQProtocolSession;
import org.wso2.andes.client.state.AMQState;
import org.wso2.andes.client.state.StateAwareMethodListener;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ConnectionOpenBody;
import org.wso2.andes.framing.ConnectionTuneBody;
import org.wso2.andes.framing.ConnectionTuneOkBody;
import org.wso2.andes.framing.MethodRegistry;

public class ConnectionTuneMethodHandler
implements StateAwareMethodListener<ConnectionTuneBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ConnectionTuneMethodHandler.class);
    private static final ConnectionTuneMethodHandler _instance = new ConnectionTuneMethodHandler();

    public static ConnectionTuneMethodHandler getInstance() {
        return _instance;
    }

    protected ConnectionTuneMethodHandler() {
    }

    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionTuneBody frame, int channelId) {
        int maxChannelNumber;
        _logger.debug("ConnectionTune frame received");
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ConnectionTuneParameters params = session.getConnectionTuneParameters();
        if (params == null) {
            params = new ConnectionTuneParameters();
        }
        params.setChannelMax((maxChannelNumber = frame.getChannelMax()) == 0 ? 65535 : maxChannelNumber);
        params.setFrameMax(frame.getFrameMax());
        params.setHeartbeat(Integer.getInteger("amqj.heartbeat.delay", frame.getHeartbeat()));
        session.setConnectionTuneParameters(params);
        session.getStateManager().changeState(AMQState.CONNECTION_NOT_OPENED);
        ConnectionTuneOkBody tuneOkBody = methodRegistry.createConnectionTuneOkBody(params.getChannelMax(), params.getFrameMax(), params.getHeartbeat());
        session.writeFrame(tuneOkBody.generateFrame(channelId));
        String host = session.getAMQConnection().getVirtualHost();
        AMQShortString virtualHost = new AMQShortString("/" + host);
        ConnectionOpenBody openBody = methodRegistry.createConnectionOpenBody(virtualHost, null, true);
        session.writeFrame(openBody.generateFrame(channelId));
    }
}

