/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.framing.AMQDataBlock;
import org.wso2.andes.framing.EncodableAMQDataBlock;

public class CompositeAMQDataBlock
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private AMQDataBlock[] _blocks;

    public CompositeAMQDataBlock(AMQDataBlock[] blocks) {
        this._blocks = blocks;
    }

    public AMQDataBlock[] getBlocks() {
        return this._blocks;
    }

    @Override
    public long getSize() {
        long frameSize = 0L;
        for (int i = 0; i < this._blocks.length; ++i) {
            frameSize += this._blocks[i].getSize();
        }
        return frameSize;
    }

    @Override
    public void writePayload(ByteBuffer buffer) {
        for (int i = 0; i < this._blocks.length; ++i) {
            this._blocks[i].writePayload(buffer);
        }
    }

    public String toString() {
        if (this._blocks == null) {
            return "No blocks contained in composite frame";
        }
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append("{");
        for (int i = 0; i < this._blocks.length; ++i) {
            buf.append(" ").append(i).append("=[").append(this._blocks[i].toString()).append("]");
        }
        buf.append("}");
        return buf.toString();
    }
}

