/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import java.util.Arrays;
import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ConnectionStartOkBody;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;

public class ConnectionStartOkBodyImpl
extends AMQMethodBody_0_9
implements ConnectionStartOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionStartOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 11;
    private final FieldTable _clientProperties;
    private final AMQShortString _mechanism;
    private final byte[] _response;
    private final AMQShortString _locale;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionStartOkBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._clientProperties = this.readFieldTable(buffer);
        this._mechanism = this.readAMQShortString(buffer);
        this._response = this.readBytes(buffer);
        this._locale = this.readAMQShortString(buffer);
    }

    public ConnectionStartOkBodyImpl(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        this._clientProperties = clientProperties;
        this._mechanism = mechanism;
        this._response = response;
        this._locale = locale;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    @Override
    public final FieldTable getClientProperties() {
        return this._clientProperties;
    }

    @Override
    public final AMQShortString getMechanism() {
        return this._mechanism;
    }

    @Override
    public final byte[] getResponse() {
        return this._response;
    }

    @Override
    public final AMQShortString getLocale() {
        return this._locale;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._clientProperties);
        size += this.getSizeOf(this._mechanism);
        size += this.getSizeOf(this._response);
        return size += this.getSizeOf(this._locale);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeFieldTable(buffer, this._clientProperties);
        this.writeAMQShortString(buffer, this._mechanism);
        this.writeBytes(buffer, this._response);
        this.writeAMQShortString(buffer, this._locale);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchConnectionStartOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartOkBodyImpl: ");
        buf.append("clientProperties=");
        buf.append(this.getClientProperties());
        buf.append(", ");
        buf.append("mechanism=");
        buf.append(this.getMechanism());
        buf.append(", ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append(", ");
        buf.append("locale=");
        buf.append(this.getLocale());
        buf.append("]");
        return buf.toString();
    }
}

