/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.StreamReturnBody;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;

public class StreamReturnBodyImpl
extends AMQMethodBody_0_9
implements StreamReturnBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new StreamReturnBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 50;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamReturnBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._replyCode = this.readUnsignedShort(buffer);
        this._replyText = this.readAMQShortString(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
    }

    public StreamReturnBodyImpl(int replyCode, AMQShortString replyText, AMQShortString exchange, AMQShortString routingKey) {
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._exchange = exchange;
        this._routingKey = routingKey;
    }

    @Override
    public int getClazz() {
        return 80;
    }

    @Override
    public int getMethod() {
        return 50;
    }

    @Override
    public final int getReplyCode() {
        return this._replyCode;
    }

    @Override
    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._replyText);
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchStreamReturn(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamReturnBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append("]");
        return buf.toString();
    }
}

