/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_91;

import java.util.Arrays;
import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.DtxRollbackBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_0_91.AMQMethodBody_0_91;
import org.wso2.andes.framing.amqp_0_91.MethodDispatcher_0_91;

public class DtxRollbackBodyImpl
extends AMQMethodBody_0_91
implements DtxRollbackBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new DtxRollbackBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 100;
    public static final int METHOD_ID = 90;
    private final int _format;
    private final byte[] _globalId;
    private final byte[] _branchId;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public DtxRollbackBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._format = this.readUnsignedShort(buffer);
        this._globalId = this.readBytes(buffer);
        this._branchId = this.readBytes(buffer);
    }

    public DtxRollbackBodyImpl(int format, byte[] globalId, byte[] branchId) {
        this._format = format;
        this._globalId = globalId;
        this._branchId = branchId;
    }

    @Override
    public int getClazz() {
        return 100;
    }

    @Override
    public int getMethod() {
        return 90;
    }

    @Override
    public final int getFormat() {
        return this._format;
    }

    @Override
    public final byte[] getGlobalId() {
        return this._globalId;
    }

    @Override
    public final byte[] getBranchId() {
        return this._branchId;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._globalId);
        return size += this.getSizeOf(this._branchId);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._format);
        this.writeBytes(buffer, this._globalId);
        this.writeBytes(buffer, this._branchId);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchDtxRollback(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[DtxRollbackBodyImpl: ");
        buf.append("format=");
        buf.append(this.getFormat());
        buf.append(", ");
        buf.append("globalId=");
        buf.append(this.getGlobalId() == null ? "null" : Arrays.toString(this.getGlobalId()));
        buf.append(", ");
        buf.append("branchId=");
        buf.append(this.getBranchId() == null ? "null" : Arrays.toString(this.getBranchId()));
        buf.append("]");
        return buf.toString();
    }
}

