/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FileDeliverBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class FileDeliverBodyImpl
extends AMQMethodBody_8_0
implements FileDeliverBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FileDeliverBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 80;
    private final AMQShortString _consumerTag;
    private final long _deliveryTag;
    private final byte _bitfield0;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final AMQShortString _identifier;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileDeliverBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._consumerTag = this.readAMQShortString(buffer);
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._identifier = this.readAMQShortString(buffer);
    }

    public FileDeliverBodyImpl(AMQShortString consumerTag, long deliveryTag, boolean redelivered, AMQShortString exchange, AMQShortString routingKey, AMQShortString identifier) {
        this._consumerTag = consumerTag;
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (redelivered) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._identifier = identifier;
    }

    @Override
    public int getClazz() {
        return 70;
    }

    @Override
    public int getMethod() {
        return 80;
    }

    @Override
    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    @Override
    public final boolean getRedelivered() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        size += this.getSizeOf(this._consumerTag);
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._identifier);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeAMQShortString(buffer, this._identifier);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchFileDeliver(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[FileDeliverBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("redelivered=");
        buf.append(this.getRedelivered());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append("]");
        return buf.toString();
    }
}

