/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.FilePublishBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class FilePublishBodyImpl
extends AMQMethodBody_8_0
implements FilePublishBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FilePublishBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 60;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final byte _bitfield0;
    private final AMQShortString _identifier;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FilePublishBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._identifier = this.readAMQShortString(buffer);
    }

    public FilePublishBodyImpl(int ticket, AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate, AMQShortString identifier) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._routingKey = routingKey;
        byte bitfield0 = 0;
        if (mandatory) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (immediate) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
        this._identifier = identifier;
    }

    @Override
    public int getClazz() {
        return 70;
    }

    @Override
    public int getMethod() {
        return 60;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public final boolean getMandatory() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getImmediate() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    public final AMQShortString getIdentifier() {
        return this._identifier;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._identifier);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeAMQShortString(buffer, this._identifier);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchFilePublish(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[FilePublishBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("mandatory=");
        buf.append(this.getMandatory());
        buf.append(", ");
        buf.append("immediate=");
        buf.append(this.getImmediate());
        buf.append(", ");
        buf.append("identifier=");
        buf.append(this.getIdentifier());
        buf.append("]");
        return buf.toString();
    }
}

