/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.jms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.jms.BrokerDetails;
import org.wso2.andes.jms.Connection;
import org.wso2.andes.jms.ConnectionURL;
import org.wso2.andes.jms.failover.FailoverExchangeMethod;
import org.wso2.andes.jms.failover.FailoverMethod;
import org.wso2.andes.jms.failover.FailoverOneTime;
import org.wso2.andes.jms.failover.FailoverRoundRobinServers;
import org.wso2.andes.jms.failover.FailoverSingleServer;
import org.wso2.andes.jms.failover.NoFailover;

public class FailoverPolicy {
    private static final Logger _logger = LoggerFactory.getLogger(FailoverPolicy.class);
    private static final long MINUTE = 60000L;
    private static final long DEFAULT_METHOD_TIMEOUT = 300000L;
    private FailoverMethod[] _methods = new FailoverMethod[1];
    private int _currentMethod;
    private int _methodsRetries;
    private int _currentRetry;
    private boolean _timing;
    private long _lastMethodTime;
    private long _lastFailTime;

    public FailoverPolicy(ConnectionURL connectionDetails, Connection conn) {
        FailoverMethod method;
        this._methodsRetries = 0;
        if (connectionDetails.getFailoverMethod() == null) {
            method = connectionDetails.getBrokerCount() > 1 ? new FailoverRoundRobinServers(connectionDetails) : new FailoverSingleServer(connectionDetails);
        } else {
            String failoverMethod = connectionDetails.getFailoverMethod();
            if (failoverMethod.equals("singlebroker")) {
                method = new FailoverSingleServer(connectionDetails);
            } else if (failoverMethod.equals("roundrobin")) {
                method = new FailoverRoundRobinServers(connectionDetails);
            } else if (failoverMethod.equals("failover_exchange")) {
                method = new FailoverExchangeMethod(connectionDetails, conn);
            } else if (failoverMethod.equals("nofailover")) {
                method = new NoFailover(connectionDetails);
            } else if (failoverMethod.equals("onetime")) {
                method = new FailoverOneTime(connectionDetails);
            } else {
                try {
                    Class[] constructorSpec = new Class[]{ConnectionURL.class};
                    Object[] params = new Object[]{connectionDetails};
                    method = (FailoverMethod)ClassLoader.getSystemClassLoader().loadClass(failoverMethod).getConstructor(constructorSpec).newInstance(params);
                }
                catch (Exception cnfe) {
                    throw new IllegalArgumentException("Unknown failover method:" + failoverMethod, cnfe);
                }
            }
        }
        if (method == null) {
            throw new IllegalArgumentException("Unknown failover method specified.");
        }
        this.reset();
        this._methods[this._currentMethod] = method;
    }

    public FailoverPolicy(FailoverMethod method) {
        this(method, 0);
    }

    public FailoverPolicy(FailoverMethod method, int retries) {
        this._methodsRetries = retries;
        this.reset();
        this._methods[this._currentMethod] = method;
    }

    private void reset() {
        this._currentMethod = 0;
        this._currentRetry = 0;
        this._timing = false;
    }

    public boolean failoverAllowed() {
        if (this._timing) {
            long now = System.currentTimeMillis();
            if (now - this._lastMethodTime >= 300000L) {
                _logger.info("Failover method timeout");
                this._lastMethodTime = now;
                if (!this.nextMethod()) {
                    return false;
                }
            } else {
                this._lastMethodTime = now;
            }
        } else {
            this._timing = true;
            this._lastFailTime = this._lastMethodTime = System.currentTimeMillis();
        }
        if (!this._methods[this._currentMethod].failoverAllowed()) {
            if (this._currentMethod < this._methods.length - 1) {
                this.nextMethod();
                _logger.info("Changing method to " + this._methods[this._currentMethod].methodName());
                return this.failoverAllowed();
            }
            return this.cycleMethods();
        }
        boolean failoverAllowed = true;
        return failoverAllowed;
    }

    private boolean nextMethod() {
        if (this._currentMethod < this._methods.length - 1) {
            ++this._currentMethod;
            this._methods[this._currentMethod].reset();
            return true;
        }
        return this.cycleMethods();
    }

    private boolean cycleMethods() {
        if (this._currentRetry < this._methodsRetries) {
            ++this._currentRetry;
            this._currentMethod = 0;
            _logger.info("Retrying methods starting with " + this._methods[this._currentMethod].methodName());
            this._methods[this._currentMethod].reset();
            return this.failoverAllowed();
        }
        _logger.debug("All failover methods exhausted");
        return false;
    }

    public void attainedConnection() {
        this._currentRetry = 0;
        this._methods[this._currentMethod].attainedConnection();
        this._timing = false;
    }

    public BrokerDetails getCurrentBrokerDetails() {
        return this._methods[this._currentMethod].getCurrentBrokerDetails();
    }

    public BrokerDetails getNextBrokerDetails() {
        return this._methods[this._currentMethod].getNextBrokerDetails();
    }

    public void setBroker(BrokerDetails broker) {
        this._methods[this._currentMethod].setBroker(broker);
    }

    public void addMethod(FailoverMethod method) {
        int len = this._methods.length + 1;
        FailoverMethod[] newMethods = new FailoverMethod[len];
        System.arraycopy(this._methods, 0, newMethods, 0, this._methods.length);
        int index = len - 1;
        newMethods[index] = method;
        this._methods = newMethods;
    }

    public void setMethodRetries(int retries) {
        this._methodsRetries = retries;
    }

    public FailoverMethod getCurrentMethod() {
        if (this._currentMethod >= 0 && this._currentMethod < this._methods.length) {
            return this._methods[this._currentMethod];
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Failover Policy:\n");
        if (this.failoverAllowed()) {
            sb.append("Failover allowed\n");
        } else {
            sb.append("Failover not allowed\n");
        }
        sb.append("Failover policy methods\n");
        for (int i = 0; i < this._methods.length; ++i) {
            if (i == this._currentMethod) {
                sb.append(">");
            }
            sb.append(this._methods[i].toString());
        }
        return sb.toString();
    }
}

