/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.jms.failover;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.jms.BrokerDetails;
import org.wso2.andes.jms.ConnectionURL;
import org.wso2.andes.jms.failover.FailoverMethod;

public class FailoverRoundRobinServers
implements FailoverMethod {
    private static final Logger _logger = LoggerFactory.getLogger(FailoverRoundRobinServers.class);
    public static final int DEFAULT_CYCLE_RETRIES = 1;
    public static final int DEFAULT_SERVER_RETRIES = 0;
    private int _currentBrokerIndex = 0;
    int _serverRetries;
    int _currentServerRetry = 0;
    int _cycleRetries;
    int _currentCycleRetries = 0;
    protected ConnectionURL _connectionDetails;

    public FailoverRoundRobinServers(ConnectionURL connectionDetails) {
        if (connectionDetails.getBrokerCount() <= 0) {
            throw new IllegalArgumentException("At least one broker details must be specified.");
        }
        this._connectionDetails = connectionDetails;
        this._currentBrokerIndex = 0;
        String cycleRetries = this._connectionDetails.getOption("cyclecount");
        this._cycleRetries = 1;
        if (cycleRetries != null) {
            try {
                this._cycleRetries = Integer.parseInt(cycleRetries);
            }
            catch (NumberFormatException nfe) {
                _logger.warn("Cannot set cycle Retries, " + cycleRetries + " is not a number. Using default: " + 1);
            }
        }
        this._currentCycleRetries = 0;
        this._serverRetries = 0;
        this._currentServerRetry = 0;
    }

    @Override
    public void reset() {
        this._currentBrokerIndex = 0;
        this._currentCycleRetries = 0;
        this._currentServerRetry = 0;
    }

    @Override
    public boolean failoverAllowed() {
        _logger.info("==== Checking failoverAllowed() ====");
        _logger.info(this.toString());
        _logger.info("====================================");
        return this._currentCycleRetries < this._cycleRetries || this._currentServerRetry < this._serverRetries;
    }

    @Override
    public void attainedConnection() {
        this._currentCycleRetries = 0;
        this._currentServerRetry = 0;
    }

    @Override
    public BrokerDetails getCurrentBrokerDetails() {
        return this._connectionDetails.getBrokerDetails(this._currentBrokerIndex);
    }

    @Override
    public BrokerDetails getNextBrokerDetails() {
        boolean doDelay = false;
        if (this._currentBrokerIndex == this._connectionDetails.getBrokerCount() - 1) {
            if (this._currentServerRetry < this._serverRetries) {
                _logger.info("Trying " + this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
                doDelay = this._currentBrokerIndex != 0;
                ++this._currentServerRetry;
            } else {
                ++this._currentCycleRetries;
                this._currentBrokerIndex = 0;
                this.setBroker(this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
                this._currentServerRetry = 0;
            }
        } else if (this._currentServerRetry < this._serverRetries) {
            _logger.info("Trying " + this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
            doDelay = this._currentBrokerIndex != 0;
            ++this._currentServerRetry;
        } else {
            ++this._currentBrokerIndex;
            this.setBroker(this._connectionDetails.getBrokerDetails(this._currentBrokerIndex));
            this._currentServerRetry = 0;
            doDelay = this._currentBrokerIndex != 0;
        }
        BrokerDetails broker = this._connectionDetails.getBrokerDetails(this._currentBrokerIndex);
        String delayStr = broker.getProperty("connectdelay");
        if (delayStr != null && doDelay) {
            Long delay = Long.parseLong(delayStr);
            _logger.info("Delay between connect retries:" + delay);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return null;
            }
        } else if (delayStr == null) {
            _logger.info("No delay between connect retries, use tcp://host:port?connectdelay='value' to enable.");
        }
        return broker;
    }

    @Override
    public void setBroker(BrokerDetails broker) {
        this._connectionDetails.addBrokerDetails(broker);
        int index = this._connectionDetails.getAllBrokerDetails().indexOf(broker);
        String serverRetries = broker.getProperty("retries");
        if (serverRetries != null) {
            try {
                this._serverRetries = Integer.parseInt(serverRetries);
            }
            catch (NumberFormatException nfe) {
                this._serverRetries = 0;
            }
        }
        this._currentServerRetry = 0;
        this._currentBrokerIndex = index;
    }

    @Override
    public void setRetries(int maxRetries) {
        this._cycleRetries = maxRetries;
    }

    @Override
    public String methodName() {
        return "Cycle Servers";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cycle Servers:\n");
        sb.append("Cycle Retries:");
        sb.append(this._cycleRetries);
        sb.append("\nCurrent Cycle:");
        sb.append(this._currentCycleRetries);
        sb.append("\nServer Retries:");
        sb.append(this._serverRetries);
        sb.append("\nCurrent Retry:");
        sb.append(this._currentServerRetry);
        sb.append("\nCurrent Broker:");
        sb.append(this._currentBrokerIndex);
        sb.append("\n");
        for (int i = 0; i < this._connectionDetails.getBrokerCount(); ++i) {
            if (i == this._currentBrokerIndex) {
                sb.append(">");
            }
            sb.append(this._connectionDetails.getBrokerDetails(i));
            sb.append("\n");
        }
        return sb.toString();
    }
}

