/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.RangeSet;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class MessageRelease
extends Method {
    public static final int TYPE = 1028;
    private short packing_flags = 0;
    private RangeSet transfers;

    @Override
    public final int getStructType() {
        return 1028;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageRelease() {
    }

    public MessageRelease(RangeSet transfers, Option ... _options) {
        if (transfers != null) {
            this.setTransfers(transfers);
        }
        block7: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SET_REDELIVERED: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block7;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block7;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block7;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block7;
                }
                case NONE: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageRelease(context, this);
    }

    public final boolean hasTransfers() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageRelease clearTransfers() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.transfers = null;
        this.dirty = true;
        return this;
    }

    public final RangeSet getTransfers() {
        return this.transfers;
    }

    public final MessageRelease setTransfers(RangeSet value) {
        this.transfers = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final MessageRelease transfers(RangeSet value) {
        return this.setTransfers(value);
    }

    public final boolean hasSetRedelivered() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageRelease clearSetRedelivered() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final boolean getSetRedelivered() {
        return this.hasSetRedelivered();
    }

    public final MessageRelease setSetRedelivered(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final MessageRelease setRedelivered(boolean value) {
        return this.setSetRedelivered(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeSequenceSet(this.transfers);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.transfers = dec.readSequenceSet();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("transfers", this.getTransfers());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("setRedelivered", this.getSetRedelivered());
        }
        return result;
    }
}

