/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class SessionAttach
extends Method {
    public static final int TYPE = 513;
    private short packing_flags = 0;
    private byte[] name;

    @Override
    public final int getStructType() {
        return 513;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 1;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public SessionAttach() {
    }

    public SessionAttach(byte[] name, Option ... _options) {
        if (name != null) {
            this.setName(name);
        }
        block7: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case FORCE: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block7;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block7;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block7;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block7;
                }
                case NONE: {
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.sessionAttach(context, this);
    }

    public final boolean hasName() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final SessionAttach clearName() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.name = null;
        this.dirty = true;
        return this;
    }

    public final byte[] getName() {
        return this.name;
    }

    public final SessionAttach setName(byte[] value) {
        this.name = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final SessionAttach name(byte[] value) {
        return this.setName(value);
    }

    public final boolean hasForce() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final SessionAttach clearForce() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final boolean getForce() {
        return this.hasForce();
    }

    public final SessionAttach setForce(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.dirty = true;
        return this;
    }

    public final SessionAttach force(boolean value) {
        return this.setForce(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeVbin16(this.name);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.name = dec.readVbin16();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("name", this.getName());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("force", this.getForce());
        }
        return result;
    }
}

