/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.Struct;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class SessionHeader
extends Struct {
    public static final int TYPE = -1;
    private byte packing_flags = 0;

    @Override
    public final int getStructType() {
        return -1;
    }

    @Override
    public final int getSizeWidth() {
        return 1;
    }

    @Override
    public final int getPackWidth() {
        return 1;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public SessionHeader() {
    }

    public SessionHeader(Option ... _options) {
        block4: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.packing_flags = (byte)(this.packing_flags | 1);
                    continue block4;
                }
                case NONE: {
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    public final boolean hasSync() {
        return (this.packing_flags & 1) != 0;
    }

    public final SessionHeader clearSync() {
        this.packing_flags = (byte)(this.packing_flags & 0xFFFFFFFE);
        this.dirty = true;
        return this;
    }

    public final boolean getSync() {
        return this.hasSync();
    }

    public final SessionHeader setSync(boolean value) {
        this.packing_flags = value ? (byte)(this.packing_flags | 1) : (byte)(this.packing_flags & 0xFFFFFFFE);
        this.dirty = true;
        return this;
    }

    public final SessionHeader sync(boolean value) {
        return this.setSync(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint8(this.packing_flags);
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (byte)dec.readUint8();
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 1) != 0) {
            result.put("sync", this.getSync());
        }
        return result;
    }
}

