/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.wso2.andes.transport.codec.AbstractEncoder;

public final class BBEncoder
extends AbstractEncoder {
    private ByteBuffer out;
    private int segment;

    public BBEncoder(int capacity) {
        this.out = ByteBuffer.allocate(capacity);
        this.out.order(ByteOrder.BIG_ENDIAN);
        this.segment = 0;
    }

    public void init() {
        this.out.clear();
        this.segment = 0;
    }

    public ByteBuffer segment() {
        int pos = this.out.position();
        this.out.position(this.segment);
        ByteBuffer slice = this.out.slice();
        slice.limit(pos - this.segment);
        this.out.position(pos);
        this.segment = pos;
        return slice;
    }

    public ByteBuffer buffer() {
        int pos = this.out.position();
        this.out.position(this.segment);
        ByteBuffer slice = this.out.slice();
        slice.limit(pos - this.segment);
        this.out.position(pos);
        return slice;
    }

    private void grow(int size) {
        ByteBuffer old = this.out;
        int capacity = old.capacity();
        this.out = ByteBuffer.allocate(Math.max(capacity + size, 2 * capacity));
        this.out.order(ByteOrder.BIG_ENDIAN);
        old.flip();
        this.out.put(old);
    }

    @Override
    protected void doPut(byte b) {
        try {
            this.out.put(b);
        }
        catch (BufferOverflowException e) {
            this.grow(1);
            this.out.put(b);
        }
    }

    @Override
    protected void doPut(ByteBuffer src) {
        try {
            this.out.put(src);
        }
        catch (BufferOverflowException e) {
            this.grow(src.remaining());
            this.out.put(src);
        }
    }

    @Override
    protected void put(byte[] bytes) {
        try {
            this.out.put(bytes);
        }
        catch (BufferOverflowException e) {
            this.grow(bytes.length);
            this.out.put(bytes);
        }
    }

    @Override
    public void writeUint8(short b) {
        assert (b < 256);
        try {
            this.out.put((byte)b);
        }
        catch (BufferOverflowException e) {
            this.grow(1);
            this.out.put((byte)b);
        }
    }

    @Override
    public void writeUint16(int s) {
        assert (s < 65536);
        try {
            this.out.putShort((short)s);
        }
        catch (BufferOverflowException e) {
            this.grow(2);
            this.out.putShort((short)s);
        }
    }

    @Override
    public void writeUint32(long i) {
        assert (i < 0x100000000L);
        try {
            this.out.putInt((int)i);
        }
        catch (BufferOverflowException e) {
            this.grow(4);
            this.out.putInt((int)i);
        }
    }

    @Override
    public void writeUint64(long l) {
        try {
            this.out.putLong(l);
        }
        catch (BufferOverflowException e) {
            this.grow(8);
            this.out.putLong(l);
        }
    }

    @Override
    public int beginSize8() {
        int pos = this.out.position();
        try {
            this.out.put((byte)0);
        }
        catch (BufferOverflowException e) {
            this.grow(1);
            this.out.put((byte)0);
        }
        return pos;
    }

    @Override
    public void endSize8(int pos) {
        int cur = this.out.position();
        this.out.put(pos, (byte)(cur - pos - 1));
    }

    @Override
    public int beginSize16() {
        int pos = this.out.position();
        try {
            this.out.putShort((short)0);
        }
        catch (BufferOverflowException e) {
            this.grow(2);
            this.out.putShort((short)0);
        }
        return pos;
    }

    @Override
    public void endSize16(int pos) {
        int cur = this.out.position();
        this.out.putShort(pos, (short)(cur - pos - 2));
    }

    @Override
    public int beginSize32() {
        int pos = this.out.position();
        try {
            this.out.putInt(0);
        }
        catch (BufferOverflowException e) {
            this.grow(4);
            this.out.putInt(0);
        }
        return pos;
    }

    @Override
    public void endSize32(int pos) {
        int cur = this.out.position();
        this.out.putInt(pos, cur - pos - 4);
    }

    @Override
    public void writeDouble(double aDouble) {
        try {
            this.out.putDouble(aDouble);
        }
        catch (BufferOverflowException exception) {
            this.grow(8);
            this.out.putDouble(aDouble);
        }
    }

    @Override
    public void writeInt16(short aShort) {
        try {
            this.out.putShort(aShort);
        }
        catch (BufferOverflowException exception) {
            this.grow(2);
            this.out.putShort(aShort);
        }
    }

    @Override
    public void writeInt32(int anInt) {
        try {
            this.out.putInt(anInt);
        }
        catch (BufferOverflowException exception) {
            this.grow(4);
            this.out.putInt(anInt);
        }
    }

    @Override
    public void writeInt64(long aLong) {
        try {
            this.out.putLong(aLong);
        }
        catch (BufferOverflowException exception) {
            this.grow(8);
            this.out.putLong(aLong);
        }
    }

    @Override
    public void writeInt8(byte aByte) {
        try {
            this.out.put(aByte);
        }
        catch (BufferOverflowException exception) {
            this.grow(1);
            this.out.put(aByte);
        }
    }

    @Override
    public void writeBin128(byte[] byteArray) {
        byte[] byArray = byteArray = byteArray != null ? byteArray : new byte[16];
        assert (byteArray.length == 16);
        try {
            this.out.put(byteArray);
        }
        catch (BufferOverflowException exception) {
            this.grow(16);
            this.out.put(byteArray);
        }
    }

    public void writeBin128(UUID id) {
        int i;
        byte[] data = new byte[16];
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        assert (data.length == 16);
        for (i = 7; i >= 0; --i) {
            data[i] = (byte)(msb & 0xFFL);
            msb >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            data[i] = (byte)(lsb & 0xFFL);
            lsb >>= 8;
        }
        this.writeBin128(data);
    }

    @Override
    public void writeFloat(float aFloat) {
        try {
            this.out.putFloat(aFloat);
        }
        catch (BufferOverflowException exception) {
            this.grow(4);
            this.out.putFloat(aFloat);
        }
    }

    @Override
    public void writeMagicNumber() {
        this.out.put("AM2".getBytes());
    }
}

