/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.wso2.andes.ssl.SSLContextFactory;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.Receiver;
import org.wso2.andes.transport.TransportException;
import org.wso2.andes.transport.network.NetworkConnection;
import org.wso2.andes.transport.network.OutgoingNetworkTransport;
import org.wso2.andes.transport.network.io.IoNetworkConnection;
import org.wso2.andes.transport.util.Logger;

public class IoNetworkTransport
implements OutgoingNetworkTransport {
    private static final Logger LOGGER;
    private Socket _socket;
    private IoNetworkConnection _connection;
    private long _timeout = 60000L;

    @Override
    public NetworkConnection connect(ConnectionSettings settings, Receiver<java.nio.ByteBuffer> delegate, SSLContextFactory sslFactory) {
        int sendBufferSize = settings.getWriteBufferSize();
        int receiveBufferSize = settings.getReadBufferSize();
        try {
            this._socket = new Socket();
            this._socket.setReuseAddress(true);
            this._socket.setTcpNoDelay(settings.isTcpNodelay());
            this._socket.setSendBufferSize(sendBufferSize);
            this._socket.setReceiveBufferSize(receiveBufferSize);
            LOGGER.debug("SO_RCVBUF : %s", this._socket.getReceiveBufferSize());
            LOGGER.debug("SO_SNDBUF : %s", this._socket.getSendBufferSize());
            InetAddress address = InetAddress.getByName(settings.getHost());
            this._socket.connect(new InetSocketAddress(address, settings.getPort()));
        }
        catch (SocketException e) {
            throw new TransportException("Error connecting to broker", e);
        }
        catch (IOException e) {
            throw new TransportException("Error connecting to broker", e);
        }
        try {
            this._connection = new IoNetworkConnection(this._socket, delegate, sendBufferSize, receiveBufferSize, this._timeout);
        }
        catch (Exception e) {
            try {
                this._socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw new TransportException("Error creating network connection", e);
        }
        return this._connection;
    }

    @Override
    public void close() {
        this._connection.close();
    }

    @Override
    public NetworkConnection getConnection() {
        return this._connection;
    }

    static {
        ByteBuffer.setAllocator(new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers(Boolean.getBoolean("amqj.enableDirectBuffers"));
        LOGGER = Logger.get(IoNetworkTransport.class);
    }
}

