/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.mina;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.filter.ReadThrottleFilterBuilder;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.util.SessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.protocol.ProtocolEngine;
import org.wso2.andes.protocol.ProtocolEngineFactory;
import org.wso2.andes.ssl.SSLContextFactory;
import org.wso2.andes.transport.network.mina.MinaNetworkConnection;

public class MinaNetworkHandler
extends IoHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MinaNetworkHandler.class);
    private ProtocolEngineFactory _factory;
    private SSLContextFactory _sslFactory = null;
    private SSLFilter sslFilter = null;

    public MinaNetworkHandler(SSLContextFactory sslFactory, ProtocolEngineFactory factory) {
        this._sslFactory = sslFactory;
        this._factory = factory;
    }

    public MinaNetworkHandler(SSLContextFactory sslFactory) {
        this(sslFactory, null);
    }

    @Override
    public void messageReceived(IoSession session, Object message) {
        ProtocolEngine engine = (ProtocolEngine)session.getAttachment();
        ByteBuffer buf = (ByteBuffer)message;
        try {
            engine.received(buf.buf());
        }
        catch (RuntimeException re) {
            engine.exception(re);
        }
    }

    @Override
    public void exceptionCaught(IoSession ioSession, Throwable throwable) throws Exception {
        ProtocolEngine engine = (ProtocolEngine)ioSession.getAttachment();
        if (engine != null) {
            log.error("Exception caught by Mina", throwable);
            engine.exception(throwable);
        } else {
            log.error("Exception caught by Mina but without protocol engine to handle it", throwable);
        }
    }

    @Override
    public void sessionCreated(IoSession ioSession) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Created session: " + ioSession.getRemoteAddress());
        }
        SessionUtil.initialize(ioSession);
        IoFilterChain chain = ioSession.getFilterChain();
        if (this._sslFactory != null) {
            chain.addFirst("sslFilter", new SSLFilter(this._sslFactory.buildServerContext()));
        }
        if (this._factory != null) {
            MinaNetworkConnection netConn = new MinaNetworkConnection(ioSession);
            ProtocolEngine engine = this._factory.newProtocolEngine(netConn);
            ioSession.setAttachment(engine);
        }
        ReadThrottleFilterBuilder readFilter = new ReadThrottleFilterBuilder();
        readFilter.setMaximumConnectionBufferSize(0x100000);
        readFilter.attach(chain);
    }

    @Override
    public void sessionClosed(IoSession ioSession) throws Exception {
        ProtocolEngine engine;
        if (log.isDebugEnabled()) {
            log.debug("closed: " + ioSession.getRemoteAddress());
        }
        if ((engine = (ProtocolEngine)ioSession.getAttachment()) != null) {
            engine.closed();
        } else {
            log.error("Unable to close ProtocolEngine as none was present");
        }
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (IdleStatus.WRITER_IDLE.equals(status)) {
            ((ProtocolEngine)session.getAttachment()).writerIdle();
        } else if (IdleStatus.READER_IDLE.equals(status)) {
            ((ProtocolEngine)session.getAttachment()).readerIdle();
        }
    }

    static {
        boolean directBuffers = Boolean.getBoolean("amqj.enableDirectBuffers");
        log.debug("Using " + (directBuffers ? "direct" : "heap") + " buffers");
        ByteBuffer.setUseDirectBuffers(directBuffers);
        ByteBuffer.setAllocator(new SimpleByteBufferAllocator());
    }
}

