/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.security.ssl;

import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.wso2.andes.transport.network.security.ssl.SSLUtil;
import org.wso2.andes.transport.util.Logger;

public class QpidClientX509KeyManager
extends X509ExtendedKeyManager {
    private static final Logger log = Logger.get(QpidClientX509KeyManager.class);
    X509ExtendedKeyManager delegate;
    String alias;

    public QpidClientX509KeyManager(String alias, String keyStorePath, String keyStorePassword, String keyStoreCertType) throws Exception {
        this.alias = alias;
        KeyStore ks = SSLUtil.getInitializedKeyStore(keyStorePath, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyStoreCertType);
        kmf.init(ks, keyStorePassword.toCharArray());
        this.delegate = (X509ExtendedKeyManager)kmf.getKeyManagers()[0];
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        log.debug("chooseClientAlias:Returning alias " + this.alias, new Object[0]);
        return this.alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.delegate.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.delegate.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        log.debug("getClientAliases:Returning alias " + this.alias, new Object[0]);
        return new String[]{this.alias};
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.delegate.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        log.debug("chooseEngineClientAlias:Returning alias " + this.alias, new Object[0]);
        return this.alias;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.delegate.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

