/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filename) {
        BufferedInputStream is = null;
        try {
            try {
                is = new BufferedInputStream(new FileInputStream(filename));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            String string = FileUtils.readStreamAsString(is);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static String readFileAsString(File file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return FileUtils.readStreamAsString(is);
    }

    private static String readStreamAsString(BufferedInputStream is) {
        try {
            int read;
            byte[] data = new byte[4096];
            StringBuffer inBuffer = new StringBuffer();
            while ((read = is.read(data)) != -1) {
                String s = new String(data, 0, read);
                inBuffer.append(s);
            }
            return inBuffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream openFileOrDefaultResource(String filename, String defaultResource, ClassLoader cl) {
        InputStream is = null;
        if (filename != null) {
            try {
                is = new BufferedInputStream(new FileInputStream(new File(filename)));
            }
            catch (FileNotFoundException e) {
                is = null;
            }
            if (is == null) {
                is = cl.getResourceAsStream(filename);
            }
        }
        if (is == null) {
            is = cl.getResourceAsStream(defaultResource);
        }
        return is;
    }

    public static void copy(File src, File dst) {
        try {
            FileUtils.copyCheckedEx(src, dst);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyCheckedEx(File src, File dst) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            if (!dst.exists()) {
                dst.createNewFile();
            }
            try (FileOutputStream out = new FileOutputStream(dst);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
        }
    }

    public static boolean deleteFile(String filePath) {
        return FileUtils.delete(new File(filePath), false);
    }

    public static boolean deleteDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        if (directory.isDirectory() && directory.listFiles().length == 0) {
            return FileUtils.delete(directory, true);
        }
        return false;
    }

    public static boolean delete(File file, boolean recursive) {
        boolean success = true;
        if (file.isDirectory()) {
            if (recursive) {
                File[] files = file.listFiles();
                if (files == null) {
                    return false;
                }
                for (int i = 0; i < files.length; ++i) {
                    success = FileUtils.delete(files[i], true) && success;
                }
                return success && file.delete();
            }
            return false;
        }
        return file.delete();
    }

    public static void copyRecursive(File source, File dst) throws FileNotFoundException, UnableToCopyException {
        if (!source.exists()) {
            throw new FileNotFoundException("Unable to copy '" + source.toString() + "' as it does not exist.");
        }
        if (dst.exists() && !dst.isDirectory()) {
            throw new IllegalArgumentException("Unable to copy '" + source.toString() + "' to '" + dst + "' a file with same name exists.");
        }
        if (source.isFile()) {
            FileUtils.copy(source, dst);
        }
        if (!dst.isDirectory() && !dst.mkdirs()) {
            throw new UnableToCopyException("Unable to create destination directory");
        }
        for (File file : source.listFiles()) {
            if (file.isFile()) {
                FileUtils.copy(file, new File(dst.toString() + File.separator + file.getName()));
                continue;
            }
            FileUtils.copyRecursive(file, new File(dst + File.separator + file.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> searchFile(File file, String search) throws IOException {
        LinkedList<String> results = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            while (reader.ready()) {
                String line = reader.readLine();
                if (!line.contains(search)) continue;
                results.add(line);
            }
        }
        return results;
    }

    public static class UnableToCopyException
    extends Exception {
        UnableToCopyException(String msg) {
            super(msg);
        }
    }
}

