/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    private static final byte[] EMPTY = new byte[0];
    private static final ThreadLocal<char[]> charbuf = new ThreadLocal<char[]>(){

        @Override
        public char[] initialValue() {
            return new char[4096];
        }
    };
    private static final Pattern VAR = Pattern.compile("(?:\\$\\{([^\\}]*)\\})|(?:\\$(\\$))");
    public static final Resolver SYSTEM_RESOLVER = new Resolver(){

        @Override
        public String resolve(String variable) {
            String result = System.getProperty(variable);
            if (result == null) {
                result = System.getenv(variable);
            }
            return result;
        }
    };

    public static final byte[] toUTF8(String str) {
        char[] chars;
        if (str == null) {
            return EMPTY;
        }
        int size = str.length();
        if (size > (chars = charbuf.get()).length) {
            chars = new char[Math.max(size, 2 * chars.length)];
            charbuf.set(chars);
        }
        str.getChars(0, size, chars, 0);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            if (chars[i] > '\u007f') {
                try {
                    return str.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static final String fromUTF8(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String expand(String input) {
        return Strings.expand(input, SYSTEM_RESOLVER);
    }

    public static final String expand(String input, Resolver resolver) {
        return Strings.expand(input, resolver, new Stack<String>());
    }

    private static final String expand(String input, Resolver resolver, Stack<String> stack) {
        Matcher m = VAR.matcher(input);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            if (var == null) {
                String esc = m.group(2);
                if ("$".equals(esc)) {
                    m.appendReplacement(result, Matcher.quoteReplacement("$"));
                    continue;
                }
                throw new IllegalArgumentException(esc);
            }
            m.appendReplacement(result, Matcher.quoteReplacement(Strings.resolve(var, resolver, stack)));
        }
        m.appendTail(result);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String resolve(String var, Resolver resolver, Stack<String> stack) {
        if (stack.contains(var)) {
            throw new IllegalArgumentException(String.format("recursively defined variable: %s stack=%s", var, stack));
        }
        String result = resolver.resolve(var);
        if (result == null) {
            throw new IllegalArgumentException("no such variable: " + var);
        }
        stack.push(var);
        try {
            String string = Strings.expand(result, resolver, stack);
            return string;
        }
        finally {
            stack.pop();
        }
    }

    public static final String join(String sep, Iterable items) {
        StringBuilder result = new StringBuilder();
        for (Object o : items) {
            if (result.length() > 0) {
                result.append(sep);
            }
            result.append(o.toString());
        }
        return result.toString();
    }

    public static final String join(String sep, Object[] items) {
        return Strings.join(sep, Arrays.asList(items));
    }

    public static class ChainedResolver
    implements Resolver {
        private final Resolver primary;
        private final Resolver secondary;

        public ChainedResolver(Resolver primary, Resolver secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public String resolve(String variable) {
            String result = this.primary.resolve(variable);
            if (result == null) {
                result = this.secondary.resolve(variable);
            }
            return result;
        }
    }

    public static class PropertiesResolver
    implements Resolver {
        private final Properties properties;

        public PropertiesResolver(Properties properties) {
            this.properties = properties;
        }

        @Override
        public String resolve(String variable) {
            return this.properties.getProperty(variable);
        }
    }

    public static class MapResolver
    implements Resolver {
        private final Map<String, String> map;

        public MapResolver(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public String resolve(String variable) {
            return this.map.get(variable);
        }
    }

    public static interface Resolver {
        public String resolve(String var1);
    }
}

