/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.dtx;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQInvalidArgumentException;
import org.wso2.andes.transport.Xid;

public class XidImpl
implements javax.transaction.xa.Xid,
Serializable {
    private static final Logger _logger = LoggerFactory.getLogger(XidImpl.class);
    private byte[] _branchQualifier;
    private int _formatID;
    private byte[] _globalTransactionID;

    public XidImpl() {
    }

    public XidImpl(javax.transaction.xa.Xid xid) {
        this._branchQualifier = xid.getBranchQualifier();
        this._formatID = xid.getFormatId();
        this._globalTransactionID = xid.getGlobalTransactionId();
    }

    public XidImpl(byte[] branchQualifier, int format, byte[] globalTransactionID) {
        this._branchQualifier = branchQualifier;
        this._formatID = format;
        this._globalTransactionID = globalTransactionID;
    }

    public XidImpl(String xid) throws AMQInvalidArgumentException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("converting string " + xid + " into XidImpl");
        }
        try {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(xid.getBytes()));
            this._formatID = (int)input.readLong();
            byte g = input.readByte();
            byte b = input.readByte();
            this._globalTransactionID = new byte[g];
            this._branchQualifier = new byte[b];
            if (input.read(this._globalTransactionID, 0, g) != g) {
                throw new AMQInvalidArgumentException("Cannot convert the string " + xid + " into an Xid", null);
            }
            if (input.read(this._branchQualifier, 0, b) != b) {
                throw new AMQInvalidArgumentException("Cannot convert the string " + xid + " into an Xid", null);
            }
        }
        catch (IOException e) {
            throw new AMQInvalidArgumentException("cannot convert the string " + xid + " into an Xid", e);
        }
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this._globalTransactionID;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this._branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this._formatID;
    }

    public static Xid convert(javax.transaction.xa.Xid xid) {
        return new Xid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFormatId() + "|" + Arrays.toString(this.getGlobalTransactionId()) + "|" + Arrays.toString(this.getBranchQualifier()) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        javax.transaction.xa.Xid that = (javax.transaction.xa.Xid)o;
        return Arrays.equals(this.getBranchQualifier(), that.getBranchQualifier()) && Arrays.equals(this.getGlobalTransactionId(), that.getGlobalTransactionId());
    }

    public int hashCode() {
        int i;
        int result = 0;
        for (i = 0; i < this.getGlobalTransactionId().length; ++i) {
            result = 31 * result + this.getGlobalTransactionId()[i];
        }
        for (i = 0; i < this.getBranchQualifier().length; ++i) {
            result = 31 * result + this.getBranchQualifier()[i];
        }
        return result;
    }
}

