/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.pool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.wso2.andes.pool.ReadWriteJobQueue;
import org.wso2.andes.pool.ReferenceCountingService;

public class ReferenceCountingExecutorService
implements ReferenceCountingService {
    private static final int MINIMUM_POOL_SIZE = 4;
    private static final int NUM_CPUS = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_POOL_SIZE = Math.max(NUM_CPUS, 4);
    private static final ReferenceCountingExecutorService _instance = new ReferenceCountingExecutorService();
    private final Object _lock = new Object();
    private ExecutorService _pool;
    private int _refCount = 0;
    private int _poolSize = Integer.getInteger("amqj.read_write_pool_size", DEFAULT_POOL_SIZE);
    private ThreadFactory _threadFactory = new ThreadFactoryBuilder().setNameFormat("JobPoolThread-%d").build();
    private final boolean _useBiasedPool = Boolean.getBoolean("org.apache.qpid.use_write_biased_pool");

    public static ReferenceCountingExecutorService getInstance() {
        return _instance;
    }

    private ReferenceCountingExecutorService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService acquireExecutorService() {
        Object object = this._lock;
        synchronized (object) {
            if (this._refCount++ == 0) {
                this._pool = this._useBiasedPool ? new ThreadPoolExecutor(this._poolSize, this._poolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ReadWriteJobQueue(), this._threadFactory) : new ThreadPoolExecutor(this._poolSize, this._poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this._threadFactory);
            }
            return this._pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExecutorService() {
        Object object = this._lock;
        synchronized (object) {
            if (--this._refCount == 0) {
                this._pool.shutdownNow();
            }
        }
    }

    @Override
    public ExecutorService getPool() {
        return this._pool;
    }

    public int getReferenceCount() {
        return this._refCount;
    }

    public ThreadFactory getThreadFactory() {
        return this._threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory cannot be null");
        }
        this._threadFactory = threadFactory;
    }
}

