/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.util.Enumeration;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.AMQSession;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.jms.Message;

public abstract class AbstractJMSMessage
implements Message {
    protected ByteBuffer _data;
    protected boolean _readableMessage = false;
    protected boolean _changedData = true;
    protected AMQMessageDelegate _delegate;
    private boolean _redelivered;

    protected AbstractJMSMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        this._delegate = delegateFactory.createDelegate();
        this._data = data;
        if (this._data != null) {
            this._data.acquire();
        }
        this._readableMessage = data != null;
        this._changedData = data == null;
    }

    protected AbstractJMSMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        this._delegate = delegate;
        this._data = data;
        if (this._data != null) {
            this._data.acquire();
        }
        this._readableMessage = data != null;
    }

    public String getJMSMessageID() throws JMSException {
        return this._delegate.getJMSMessageID();
    }

    public void setJMSMessageID(String messageId) throws JMSException {
        this._delegate.setJMSMessageID(messageId);
    }

    public void setJMSMessageID(UUID messageId) throws JMSException {
        this._delegate.setJMSMessageID(messageId);
    }

    public long getJMSTimestamp() throws JMSException {
        return this._delegate.getJMSTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._delegate.setJMSTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this._delegate.getJMSCorrelationIDAsBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] bytes) throws JMSException {
        this._delegate.setJMSCorrelationIDAsBytes(bytes);
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this._delegate.setJMSCorrelationID(correlationId);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this._delegate.getJMSCorrelationID();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this._delegate.getJMSReplyTo();
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this._delegate.setJMSReplyTo(destination);
    }

    public Destination getJMSDestination() throws JMSException {
        return this._delegate.getJMSDestination();
    }

    public void setJMSDestination(Destination destination) {
        this._delegate.setJMSDestination(destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this._delegate.getJMSDeliveryMode();
    }

    public void setJMSDeliveryMode(int i) throws JMSException {
        this._delegate.setJMSDeliveryMode(i);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._redelivered;
    }

    public void setJMSRedelivered(boolean b) throws JMSException {
        this._redelivered = b;
    }

    public String getJMSType() throws JMSException {
        return this._delegate.getJMSType();
    }

    public void setJMSType(String string) throws JMSException {
        this._delegate.setJMSType(string);
    }

    public long getJMSExpiration() throws JMSException {
        return this._delegate.getJMSExpiration();
    }

    public void setJMSExpiration(long l) throws JMSException {
        this._delegate.setJMSExpiration(l);
    }

    public int getJMSPriority() throws JMSException {
        return this._delegate.getJMSPriority();
    }

    public void setJMSPriority(int i) throws JMSException {
        this._delegate.setJMSPriority(i);
    }

    public boolean propertyExists(String propertyName) throws JMSException {
        return this._delegate.propertyExists(propertyName);
    }

    public boolean getBooleanProperty(String s) throws JMSException {
        return this._delegate.getBooleanProperty(s);
    }

    public byte getByteProperty(String s) throws JMSException {
        return this._delegate.getByteProperty(s);
    }

    public short getShortProperty(String s) throws JMSException {
        return this._delegate.getShortProperty(s);
    }

    public int getIntProperty(String s) throws JMSException {
        return this._delegate.getIntProperty(s);
    }

    public long getLongProperty(String s) throws JMSException {
        return this._delegate.getLongProperty(s);
    }

    public float getFloatProperty(String s) throws JMSException {
        return this._delegate.getFloatProperty(s);
    }

    public double getDoubleProperty(String s) throws JMSException {
        return this._delegate.getDoubleProperty(s);
    }

    public String getStringProperty(String s) throws JMSException {
        return this._delegate.getStringProperty(s);
    }

    public Object getObjectProperty(String s) throws JMSException {
        return this._delegate.getObjectProperty(s);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this._delegate.getPropertyNames();
    }

    public void setBooleanProperty(String s, boolean b) throws JMSException {
        this._delegate.setBooleanProperty(s, b);
    }

    public void setByteProperty(String s, byte b) throws JMSException {
        this._delegate.setByteProperty(s, b);
    }

    public void setShortProperty(String s, short i) throws JMSException {
        this._delegate.setShortProperty(s, i);
    }

    public void setIntProperty(String s, int i) throws JMSException {
        this._delegate.setIntProperty(s, i);
    }

    public void setLongProperty(String s, long l) throws JMSException {
        this._delegate.setLongProperty(s, l);
    }

    public void setFloatProperty(String s, float v) throws JMSException {
        this._delegate.setFloatProperty(s, v);
    }

    public void setDoubleProperty(String s, double v) throws JMSException {
        this._delegate.setDoubleProperty(s, v);
    }

    public void setStringProperty(String s, String s1) throws JMSException {
        this._delegate.setStringProperty(s, s1);
    }

    public void setObjectProperty(String s, Object o) throws JMSException {
        this._delegate.setObjectProperty(s, o);
    }

    public void clearProperties() throws JMSException {
        this._delegate.clearProperties();
    }

    public void clearBody() throws JMSException {
        this.clearBodyImpl();
        this._readableMessage = false;
    }

    @Override
    public void acknowledgeThis() throws JMSException {
        this._delegate.acknowledgeThis();
    }

    public void acknowledge() throws JMSException {
        this._delegate.acknowledge();
    }

    public abstract void clearBodyImpl() throws JMSException;

    public abstract String toBodyString() throws JMSException;

    protected abstract String getMimeType();

    public String toString() {
        try {
            StringBuffer buf = new StringBuffer("Body:\n");
            buf.append(this.toBodyString());
            buf.append("\nJMS Correlation ID: ").append(this.getJMSCorrelationID());
            buf.append("\nJMS timestamp: ").append(this.getJMSTimestamp());
            buf.append("\nJMS expiration: ").append(this.getJMSExpiration());
            buf.append("\nJMS priority: ").append(this.getJMSPriority());
            buf.append("\nJMS delivery mode: ").append(this.getJMSDeliveryMode());
            buf.append("\nJMS reply to: ").append(this.getReplyToString());
            buf.append("\nJMS Redelivered: ").append(this._redelivered);
            buf.append("\nJMS Destination: ").append(this.getJMSDestination());
            buf.append("\nJMS Type: ").append(this.getJMSType());
            buf.append("\nJMS MessageID: ").append(this.getJMSMessageID());
            buf.append("\nJMS Content-Type: ").append(this.getContentType());
            buf.append("\nAMQ message number: ").append(this.getDeliveryTag());
            buf.append("\nProperties:");
            Enumeration propertyNames = this.getPropertyNames();
            if (!propertyNames.hasMoreElements()) {
                buf.append("<NONE>");
            } else {
                buf.append('\n');
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    buf.append("\t").append(propertyName).append(" = ").append(this.getObjectProperty(propertyName)).append("\n");
                }
            }
            return buf.toString();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public AMQMessageDelegate getDelegate() {
        return this._delegate;
    }

    public ByteBuffer getData() {
        if (this._data != null) {
            this.reset();
        }
        return this._data;
    }

    protected void checkReadable() throws MessageNotReadableException {
        if (!this._readableMessage) {
            throw new MessageNotReadableException("You need to call reset() to make the message readable");
        }
    }

    protected void checkWritable() throws MessageNotWriteableException {
        if (this._readableMessage) {
            throw new MessageNotWriteableException("You need to call clearBody() to make the message writable");
        }
    }

    public void reset() {
        if (!this._changedData) {
            this._data.rewind();
        } else {
            this._data.flip();
            this._changedData = false;
        }
    }

    public int getContentLength() {
        if (this._data != null) {
            return this._data.remaining();
        }
        return 0;
    }

    public void receivedFromServer() {
        this._changedData = false;
    }

    public void setAMQSession(AMQSession s) {
        this._delegate.setAMQSession(s);
    }

    public AMQSession getAMQSession() {
        return this._delegate.getAMQSession();
    }

    public long getDeliveryTag() {
        return this._delegate.getDeliveryTag();
    }

    public void prepareForSending() throws JMSException {
    }

    public void setContentType(String contentType) {
        this._delegate.setContentType(contentType);
    }

    public String getContentType() {
        return this._delegate.getContentType();
    }

    public void setEncoding(String encoding) {
        this._delegate.setEncoding(encoding);
    }

    public String getEncoding() {
        return this._delegate.getEncoding();
    }

    public String getReplyToString() {
        return this._delegate.getReplyToString();
    }

    protected void removeProperty(String propertyName) throws JMSException {
        this._delegate.removeProperty(propertyName);
    }
}

