/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.AMQTimeoutException;
import org.wso2.andes.client.failover.FailoverException;

public abstract class BlockingWaiter<T> {
    private static final Logger logger = LoggerFactory.getLogger(BlockingWaiter.class);
    private volatile boolean _ready = false;
    private volatile boolean _errorAck = false;
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _receivedCondition = this._lock.newCondition();
    private final Condition _errorConditionAck = this._lock.newCondition();
    private volatile Exception _error;
    protected Object _doneObject = null;
    private AtomicBoolean _waiting = new AtomicBoolean(false);
    private boolean _closed = false;

    public abstract boolean process(T var1);

    public boolean received(T object) {
        boolean ready = this.process(object);
        if (ready) {
            this._lock.lock();
            try {
                this._doneObject = object;
                this._ready = true;
                this._receivedCondition.signal();
            }
            finally {
                this._lock.unlock();
            }
        }
        return ready;
    }

    public Object block(long timeout) throws AMQException, FailoverException {
        this._lock.lock();
        try {
            this.waitForFrame(timeout);
        }
        finally {
            this._waiting.set(false);
            if (this._error != null) {
                this._errorAck = true;
                this._errorConditionAck.signal();
                this._error = null;
            }
            this._lock.unlock();
        }
        return this._doneObject;
    }

    private void waitForFrame(long timeout) throws AMQException, FailoverException {
        long nanoTimeout = TimeUnit.MILLISECONDS.toNanos(timeout);
        if (this._closed) {
            throw this.throwClosedException();
        }
        if (this._error == null) {
            this._waiting.set(true);
            while (!this._ready) {
                try {
                    if (timeout == -1L) {
                        this._receivedCondition.await();
                        continue;
                    }
                    if ((nanoTimeout = this._receivedCondition.awaitNanos(nanoTimeout)) > 0L || this._ready || this._error != null) continue;
                    this._error = new AMQTimeoutException("Server did not respond in a timely fashion", null);
                    this._ready = true;
                }
                catch (InterruptedException e) {
                    logger.error("Waiting for AMQP frame interrupted", (Throwable)e);
                }
            }
        }
        if (this._error != null) {
            if (this._error instanceof AMQException) {
                throw (AMQException)this._error;
            }
            if (this._error instanceof FailoverException) {
                throw (FailoverException)this._error;
            }
            throw new AMQException("Woken up due to " + this._error.getClass(), this._error);
        }
    }

    public void error(Exception e) {
        this._lock.lock();
        try {
            if (this._closed) {
                return;
            }
            if (this._error == null) {
                this._error = e;
            } else if (e != null) {
                logger.warn("new error [ " + e.getMessage() + " ] arrived while old one [ " + this._error.getMessage() + " ] not yet processed:", (Throwable)e);
            }
            if (this._waiting.get()) {
                this._ready = true;
                this._receivedCondition.signal();
                while (!this._errorAck) {
                    try {
                        this._errorConditionAck.await();
                    }
                    catch (InterruptedException e1) {
                        logger.error("Interrupted ", (Throwable)e);
                    }
                }
                this._errorAck = false;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void close() {
        this._lock.lock();
        try {
            if (this._closed) {
                return;
            }
            this._closed = true;
            if (this._waiting.get()) {
                this.error(this.throwClosedException());
            }
            if (!this._errorAck) {
                this._errorAck = true;
                this._errorConditionAck.signal();
                this._error = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private AMQException throwClosedException() {
        return new AMQException(null, "Waiter was closed.", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object writeAndWait(Runnable action, long timeout) throws FailoverException, AMQException {
        this._lock.lock();
        try {
            action.run();
            this.waitForFrame(timeout);
        }
        finally {
            this._waiting.set(false);
            if (this._error != null) {
                this._errorAck = true;
                this._errorConditionAck.signal();
                this._error = null;
            }
            this._lock.unlock();
        }
        return this._doneObject;
    }
}

