/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQInternalException;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.filter.BooleanExpression;
import org.wso2.andes.filter.MessageFilter;
import org.wso2.andes.filter.selector.SelectorParser;

public class JMSSelectorFilter
implements MessageFilter {
    private static final Logger _logger = LoggerFactory.getLogger(JMSSelectorFilter.class);
    private String _selector;
    private BooleanExpression _matcher;

    public JMSSelectorFilter(String selector) throws AMQInternalException {
        this._selector = selector;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Created JMSSelectorFilter with selector:" + this._selector);
        }
        this._matcher = new SelectorParser().parse(selector);
    }

    @Override
    public boolean matches(AbstractJMSMessage message) {
        try {
            boolean match = this._matcher.matches(message);
            if (_logger.isDebugEnabled()) {
                _logger.debug(message + " match(" + match + ") selector(" + System.identityHashCode(this._selector) + "):" + this._selector);
            }
            return match;
        }
        catch (AMQInternalException e) {
            _logger.warn("Caght exception when evaluating message selector for message  " + message, (Throwable)e);
            return false;
        }
    }

    public String getSelector() {
        return this._selector;
    }
}

