/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.ExchangeDeleteBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class ExchangeDeleteBodyImpl
extends AMQMethodBody_8_0
implements ExchangeDeleteBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ExchangeDeleteBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 40;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ExchangeDeleteBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public ExchangeDeleteBodyImpl(int ticket, AMQShortString exchange, boolean ifUnused, boolean nowait) {
        this._ticket = ticket;
        this._exchange = exchange;
        byte bitfield0 = 0;
        if (ifUnused) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 40;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final boolean getIfUnused() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getNowait() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._exchange);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchExchangeDelete(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ExchangeDeleteBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("ifUnused=");
        buf.append(this.getIfUnused());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }
}

