/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.FileQosBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class FileQosBodyImpl
extends AMQMethodBody_8_0
implements FileQosBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new FileQosBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 70;
    public static final int METHOD_ID = 10;
    private final long _prefetchSize;
    private final int _prefetchCount;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public FileQosBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._prefetchSize = this.readUnsignedInteger(buffer);
        this._prefetchCount = this.readUnsignedShort(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public FileQosBodyImpl(long prefetchSize, int prefetchCount, boolean global) {
        this._prefetchSize = prefetchSize;
        this._prefetchCount = prefetchCount;
        byte bitfield0 = 0;
        if (global) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 70;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final long getPrefetchSize() {
        return this._prefetchSize;
    }

    @Override
    public final int getPrefetchCount() {
        return this._prefetchCount;
    }

    @Override
    public final boolean getGlobal() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 7;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedInteger(buffer, this._prefetchSize);
        this.writeUnsignedShort(buffer, this._prefetchCount);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchFileQos(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[FileQosBodyImpl: ");
        buf.append("prefetchSize=");
        buf.append(this.getPrefetchSize());
        buf.append(", ");
        buf.append("prefetchCount=");
        buf.append(this.getPrefetchCount());
        buf.append(", ");
        buf.append("global=");
        buf.append(this.getGlobal());
        buf.append("]");
        return buf.toString();
    }
}

