/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExecutorThreadModel;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.apache.mina.transport.socket.nio.SocketConnector;
import org.apache.mina.transport.socket.nio.SocketConnectorConfig;
import org.apache.mina.transport.socket.nio.SocketSessionConfig;
import org.apache.mina.util.NewThreadExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.protocol.ProtocolEngineFactory;
import org.wso2.andes.ssl.SSLContextFactory;
import org.wso2.andes.thread.QpidThreadExecutor;
import org.wso2.andes.transport.ConnectionSettings;
import org.wso2.andes.transport.NetworkTransportConfiguration;
import org.wso2.andes.transport.Receiver;
import org.wso2.andes.transport.SocketConnectorFactory;
import org.wso2.andes.transport.TransportException;
import org.wso2.andes.transport.network.IncomingNetworkTransport;
import org.wso2.andes.transport.network.NetworkConnection;
import org.wso2.andes.transport.network.OutgoingNetworkTransport;
import org.wso2.andes.transport.network.mina.MinaNetworkConnection;
import org.wso2.andes.transport.network.mina.MinaNetworkHandler;
import org.wso2.andes.transport.network.security.ssl.SSLUtil;

public class MinaNetworkTransport
implements OutgoingNetworkTransport,
IncomingNetworkTransport {
    private static final int UNKNOWN = -1;
    private static final int TCP = 0;
    public NetworkConnection _connection;
    private SocketAcceptor _acceptor;
    private InetSocketAddress _address;

    @Override
    public NetworkConnection connect(ConnectionSettings settings, Receiver<ByteBuffer> delegate, SSLContextFactory sslFactory) {
        int transport = MinaNetworkTransport.getTransport(settings.getProtocol());
        switch (transport) {
            case 0: {
                IoConnectorCreator stc = new IoConnectorCreator(new SocketConnectorFactory(){

                    @Override
                    public IoConnector newConnector() {
                        return new SocketConnector(1, new QpidThreadExecutor());
                    }
                });
                this._connection = stc.connect(delegate, settings, sslFactory);
                break;
            }
            default: {
                throw new TransportException("Unknown protocol: " + settings.getProtocol());
            }
        }
        return this._connection;
    }

    private static int getTransport(String transport) {
        if (transport.equals("tcp")) {
            return 0;
        }
        return -1;
    }

    @Override
    public void close() {
        if (this._connection != null) {
            this._connection.close();
        }
        if (this._acceptor != null) {
            this._acceptor.unbindAll();
        }
    }

    @Override
    public NetworkConnection getConnection() {
        return this._connection;
    }

    @Override
    public void accept(NetworkTransportConfiguration config, ProtocolEngineFactory factory, SSLContextFactory sslFactory) {
        int processors = config.getConnectorProcessors();
        if ("tcp".equalsIgnoreCase(config.getTransport())) {
            this._acceptor = new SocketAcceptor(processors, new NewThreadExecutor());
            SocketAcceptorConfig sconfig = this._acceptor.getDefaultConfig();
            sconfig.setThreadModel(ExecutorThreadModel.getInstance("MinaNetworkTransport(Acceptor)"));
            SocketSessionConfig sc = sconfig.getSessionConfig();
            sc.setTcpNoDelay(config.getTcpNoDelay());
            sc.setSendBufferSize(config.getSendBufferSize());
            sc.setReceiveBufferSize(config.getReceiveBufferSize());
            this._address = config.getHost().equals("*") ? new InetSocketAddress(config.getPort()) : new InetSocketAddress(config.getHost(), (int)config.getPort());
        } else {
            throw new TransportException("Unknown transport: " + config.getTransport());
        }
        try {
            this._acceptor.bind(this._address, new MinaNetworkHandler(sslFactory, factory));
        }
        catch (IOException e) {
            throw new TransportException("Could not bind to " + this._address, e);
        }
    }

    private static class IoConnectorCreator {
        private static final Logger LOGGER = LoggerFactory.getLogger(IoConnectorCreator.class);
        private static final int CLIENT_DEFAULT_BUFFER_SIZE = 32768;
        private SocketConnectorFactory _ioConnectorFactory;

        public IoConnectorCreator(SocketConnectorFactory socketConnectorFactory) {
            this._ioConnectorFactory = socketConnectorFactory;
        }

        public NetworkConnection connect(Receiver<ByteBuffer> receiver, ConnectionSettings settings, SSLContextFactory sslFactory) {
            IoConnector ioConnector = this._ioConnectorFactory.newConnector();
            String protocol = settings.getProtocol();
            int port = settings.getPort();
            if (!"tcp".equalsIgnoreCase(protocol)) {
                throw new TransportException("Unknown transport: " + protocol);
            }
            InetSocketAddress address = new InetSocketAddress(settings.getHost(), port);
            LOGGER.debug("Attempting connection to " + address);
            if (ioConnector instanceof SocketConnector) {
                SocketConnectorConfig cfg = (SocketConnectorConfig)ioConnector.getDefaultConfig();
                cfg.setThreadModel(ExecutorThreadModel.getInstance("MinaNetworkTransport(Client)"));
                SocketSessionConfig scfg = cfg.getSessionConfig();
                scfg.setTcpNoDelay(true);
                scfg.setSendBufferSize(32768);
                scfg.setReceiveBufferSize(32768);
                ((SocketConnector)ioConnector).setWorkerTimeout(0);
            }
            if (settings.isUseSSL()) {
                try {
                    SSLContext sslContext = SSLUtil.createSSLContext(settings);
                    SSLFilter sslFilter = new SSLFilter(sslContext);
                    sslFilter.setUseClientMode(true);
                    ioConnector.getFilterChain().addFirst("sslFilter", sslFilter);
                }
                catch (Exception e) {
                    Exception ex = new Exception("An exception occurred in creating SSLContext: ", e);
                    ex.printStackTrace();
                }
            }
            ConnectFuture future = ioConnector.connect((SocketAddress)address, new MinaNetworkHandler(null), ioConnector.getDefaultConfig());
            future.join();
            if (!future.isConnected()) {
                throw new TransportException("Could not open connection");
            }
            IoSession session = future.getSession();
            session.setAttachment(receiver);
            return new MinaNetworkConnection(session);
        }
    }
}

