/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.support.SSLByteBufferPool;
import org.apache.mina.util.SessionLog;

public class SSLHandler {
    private final SSLFilter parent;
    private final SSLContext ctx;
    private final IoSession session;
    private final Queue<Event> preHandshakeEventQueue = new LinkedList<Event>();
    private final Queue<Event> filterWriteEventQueue = new ConcurrentLinkedQueue<Event>();
    private final Queue<Event> messageReceivedEventQueue = new ConcurrentLinkedQueue<Event>();
    private SSLEngine sslEngine;
    private java.nio.ByteBuffer inNetBuffer;
    private java.nio.ByteBuffer outNetBuffer;
    private java.nio.ByteBuffer appBuffer;
    private final java.nio.ByteBuffer hsBB = java.nio.ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean handshakeComplete;
    private boolean writingEncryptedData;

    public SSLHandler(SSLFilter parent, SSLContext sslc, IoSession session) throws SSLException {
        this.parent = parent;
        this.session = session;
        this.ctx = sslc;
        this.init();
    }

    public void init() throws SSLException {
        if (this.sslEngine != null) {
            return;
        }
        this.sslEngine = this.ctx.createSSLEngine();
        this.sslEngine.setUseClientMode(this.parent.isUseClientMode());
        if (this.parent.isWantClientAuth()) {
            this.sslEngine.setWantClientAuth(true);
        }
        if (this.parent.isNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        }
        if (this.parent.getEnabledCipherSuites() != null) {
            this.sslEngine.setEnabledCipherSuites(this.parent.getEnabledCipherSuites());
        }
        if (this.parent.getEnabledProtocols() != null) {
            this.sslEngine.setEnabledProtocols(this.parent.getEnabledProtocols());
        }
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.handshakeComplete = false;
        this.initialHandshakeComplete = false;
        SSLByteBufferPool.initiate(this.sslEngine);
        this.appBuffer = SSLByteBufferPool.getApplicationBuffer();
        this.inNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer.position(0);
        this.outNetBuffer.limit(0);
        this.writingEncryptedData = false;
    }

    public void destroy() {
        if (this.sslEngine == null) {
            return;
        }
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException e) {
            SessionLog.debug(this.session, "Unexpected exception from SSLEngine.closeInbound().", e);
        }
        try {
            do {
                this.outNetBuffer.clear();
            } while (this.sslEngine.wrap(this.hsBB, this.outNetBuffer).bytesProduced() > 0);
        }
        catch (SSLException e) {
            SessionLog.debug(this.session, "Unexpected exception from SSLEngine.wrap().", e);
        }
        this.sslEngine.closeOutbound();
        this.sslEngine = null;
        SSLByteBufferPool.release(this.appBuffer);
        SSLByteBufferPool.release(this.inNetBuffer);
        SSLByteBufferPool.release(this.outNetBuffer);
        this.preHandshakeEventQueue.clear();
    }

    public SSLFilter getParent() {
        return this.parent;
    }

    public IoSession getSession() {
        return this.session;
    }

    public boolean isWritingEncryptedData() {
        return this.writingEncryptedData;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    public boolean isInboundDone() {
        return this.sslEngine == null || this.sslEngine.isInboundDone();
    }

    public boolean isOutboundDone() {
        return this.sslEngine == null || this.sslEngine.isOutboundDone();
    }

    public boolean needToCompleteHandshake() {
        return this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    public void schedulePreHandshakeWriteRequest(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        this.preHandshakeEventQueue.offer(new Event(EventType.FILTER_WRITE, nextFilter, writeRequest));
    }

    public void flushPreHandshakeEvents() throws SSLException {
        Event scheduledWrite;
        while ((scheduledWrite = this.preHandshakeEventQueue.poll()) != null) {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " Flushing buffered write request: " + scheduledWrite.data);
            }
            this.parent.filterWrite(scheduledWrite.nextFilter, this.session, (IoFilter.WriteRequest)scheduledWrite.data);
        }
    }

    public void scheduleFilterWrite(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        this.filterWriteEventQueue.offer(new Event(EventType.FILTER_WRITE, nextFilter, writeRequest));
    }

    public void scheduleMessageReceived(IoFilter.NextFilter nextFilter, Object message) {
        this.messageReceivedEventQueue.offer(new Event(EventType.RECEIVED, nextFilter, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushScheduledEvents() {
        Event e;
        if (Thread.holdsLock(this)) {
            return;
        }
        SSLHandler sSLHandler = this;
        synchronized (sSLHandler) {
            while ((e = this.filterWriteEventQueue.poll()) != null) {
                e.nextFilter.filterWrite(this.session, (IoFilter.WriteRequest)e.data);
            }
        }
        while ((e = this.messageReceivedEventQueue.poll()) != null) {
            e.nextFilter.messageReceived(this.session, e.data);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, java.nio.ByteBuffer buf) throws SSLException {
        if (buf.limit() > this.inNetBuffer.remaining()) {
            this.inNetBuffer = SSLByteBufferPool.expandBuffer(this.inNetBuffer, this.inNetBuffer.capacity() + buf.limit() * 2);
            this.appBuffer = SSLByteBufferPool.expandBuffer(this.appBuffer, this.inNetBuffer.capacity() * 2);
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " expanded inNetBuffer:" + this.inNetBuffer);
                SessionLog.debug(this.session, " expanded appBuffer:" + this.appBuffer);
            }
        }
        this.inNetBuffer.put(buf);
        if (!this.handshakeComplete) {
            this.handshake(nextFilter);
        } else {
            this.decrypt(nextFilter);
        }
        if (this.isInboundDone()) {
            buf.position(buf.position() - this.inNetBuffer.position());
            this.inNetBuffer.clear();
        }
    }

    public java.nio.ByteBuffer getAppBuffer() {
        return this.appBuffer;
    }

    public java.nio.ByteBuffer getOutNetBuffer() {
        return this.outNetBuffer;
    }

    public void encrypt(java.nio.ByteBuffer src) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        this.outNetBuffer.clear();
        int bufferExpansionCount = 0;
        while (src.hasRemaining()) {
            if (src.remaining() > (this.outNetBuffer.capacity() - this.outNetBuffer.position()) / 2) {
                this.outNetBuffer = SSLByteBufferPool.expandBuffer(this.outNetBuffer, src.capacity() * 2);
                ++bufferExpansionCount;
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, " expanded outNetBuffer:" + this.outNetBuffer);
                }
            }
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer);
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " Wrap res:" + result);
            }
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && bufferExpansionCount < 3) {
                this.outNetBuffer = SSLByteBufferPool.expandBuffer(this.outNetBuffer, this.outNetBuffer.capacity() * 2);
                ++bufferExpansionCount;
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)result.getStatus()) + " src: " + src + "outNetBuffer: " + this.outNetBuffer);
        }
        this.outNetBuffer.flip();
    }

    public boolean closeOutbound() throws SSLException {
        if (this.sslEngine == null || this.sslEngine.isOutboundDone()) {
            return false;
        }
        this.sslEngine.closeOutbound();
        this.outNetBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
        if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + result);
        }
        this.outNetBuffer.flip();
        return true;
    }

    private void decrypt(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.handshakeComplete) {
            throw new IllegalStateException();
        }
        this.unwrap(nextFilter);
    }

    private void checkStatus(SSLEngineResult res) throws SSLException {
        SSLEngineResult.Status status = res.getStatus();
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
    }

    public void handshake(IoFilter.NextFilter nextFilter) throws SSLException {
        block13: {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " doHandshake()");
            }
            while (true) {
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.session.setAttribute(SSLFilter.SSL_SESSION, this.sslEngine.getSession());
                    if (SessionLog.isDebugEnabled(this.session)) {
                        SSLSession sslSession = this.sslEngine.getSession();
                        SessionLog.debug(this.session, "  handshakeStatus=FINISHED");
                        SessionLog.debug(this.session, "  sslSession CipherSuite used " + sslSession.getCipherSuite());
                    }
                    this.handshakeComplete = true;
                    if (!this.initialHandshakeComplete && this.session.containsAttribute(SSLFilter.USE_NOTIFICATION)) {
                        this.initialHandshakeComplete = true;
                        this.scheduleMessageReceived(nextFilter, SSLFilter.SESSION_SECURED);
                    }
                    break block13;
                }
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    if (SessionLog.isDebugEnabled(this.session)) {
                        SessionLog.debug(this.session, "  handshakeStatus=NEED_TASK");
                    }
                    this.handshakeStatus = this.doTasks();
                    continue;
                }
                if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    SSLEngineResult.Status status;
                    if (SessionLog.isDebugEnabled(this.session)) {
                        SessionLog.debug(this.session, "  handshakeStatus=NEED_UNWRAP");
                    }
                    if (((status = this.unwrapHandshake(nextFilter)) != SSLEngineResult.Status.BUFFER_UNDERFLOW || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) && !this.isInboundDone()) continue;
                    break block13;
                }
                if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, "  handshakeStatus=NEED_WRAP");
                }
                if (this.outNetBuffer.hasRemaining()) {
                    if (SessionLog.isDebugEnabled(this.session)) {
                        SessionLog.debug(this.session, "  Still data in out buffer!");
                    }
                    break block13;
                }
                this.outNetBuffer.clear();
                SSLEngineResult result = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, " Wrap res:" + result);
                }
                this.outNetBuffer.flip();
                this.handshakeStatus = result.getHandshakeStatus();
                this.writeNetBuffer(nextFilter);
            }
            throw new IllegalStateException("Invalid Handshaking State" + (Object)((Object)this.handshakeStatus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writeNetBuffer(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.getOutNetBuffer().hasRemaining()) {
            return DefaultWriteFuture.newNotWrittenFuture(this.session);
        }
        this.writingEncryptedData = true;
        DefaultWriteFuture writeFuture = null;
        try {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " write outNetBuffer: " + this.getOutNetBuffer());
            }
            ByteBuffer writeBuffer = SSLHandler.copy(this.getOutNetBuffer());
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, " session write: " + writeBuffer);
            }
            writeFuture = new DefaultWriteFuture(this.session);
            this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest(writeBuffer, writeFuture));
            while (this.needToCompleteHandshake()) {
                try {
                    this.handshake(nextFilter);
                }
                catch (SSLException ssle) {
                    SSLHandshakeException newSSLE = new SSLHandshakeException("SSL handshake failed.");
                    newSSLE.initCause(ssle);
                    throw newSSLE;
                }
                if (!this.getOutNetBuffer().hasRemaining()) continue;
                if (SessionLog.isDebugEnabled(this.session)) {
                    SessionLog.debug(this.session, " write outNetBuffer2: " + this.getOutNetBuffer());
                }
                ByteBuffer writeBuffer2 = SSLHandler.copy(this.getOutNetBuffer());
                writeFuture = new DefaultWriteFuture(this.session);
                this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest(writeBuffer2, writeFuture));
            }
        }
        finally {
            this.writingEncryptedData = false;
        }
        return writeFuture;
    }

    private void unwrap(IoFilter.NextFilter nextFilter) throws SSLException {
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, " unwrap()");
        }
        this.inNetBuffer.flip();
        SSLEngineResult res = this.unwrap0();
        this.inNetBuffer.compact();
        this.checkStatus(res);
        this.renegotiateIfNeeded(nextFilter, res);
    }

    private SSLEngineResult.Status unwrapHandshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, " unwrapHandshake()");
        }
        this.inNetBuffer.flip();
        SSLEngineResult res = this.unwrap0();
        this.handshakeStatus = res.getHandshakeStatus();
        this.checkStatus(res);
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            res = this.unwrap0();
            this.inNetBuffer.compact();
            this.renegotiateIfNeeded(nextFilter, res);
        } else {
            this.inNetBuffer.compact();
        }
        return res.getStatus();
    }

    private void renegotiateIfNeeded(IoFilter.NextFilter nextFilter, SSLEngineResult res) throws SSLException {
        if (res.getStatus() != SSLEngineResult.Status.CLOSED && res.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && res.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            SessionLog.debug(this.session, " Renegotiating...");
            this.handshakeComplete = false;
            this.handshakeStatus = res.getHandshakeStatus();
            this.handshake(nextFilter);
        }
    }

    private SSLEngineResult unwrap0() throws SSLException {
        SSLEngineResult res;
        do {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, "   inNetBuffer: " + this.inNetBuffer);
                SessionLog.debug(this.session, "   appBuffer: " + this.appBuffer);
            }
            res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!SessionLog.isDebugEnabled(this.session)) continue;
            SessionLog.debug(this.session, " Unwrap res:" + res);
        } while (res.getStatus() == SSLEngineResult.Status.OK && (this.handshakeComplete && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP));
        return res;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, "   doTasks()");
        }
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (SessionLog.isDebugEnabled(this.session)) {
                SessionLog.debug(this.session, "    doTask: " + runnable);
            }
            runnable.run();
        }
        if (SessionLog.isDebugEnabled(this.session)) {
            SessionLog.debug(this.session, "   doTasks(): " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public static ByteBuffer copy(java.nio.ByteBuffer src) {
        ByteBuffer copy = ByteBuffer.allocate(src.remaining());
        copy.put(src);
        copy.flip();
        return copy;
    }

    private static class Event {
        private final EventType type;
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        Event(EventType type, IoFilter.NextFilter nextFilter, Object data) {
            this.type = type;
            this.nextFilter = nextFilter;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public IoFilter.NextFilter getNextFilter() {
            return this.nextFilter;
        }

        public EventType getType() {
            return this.type;
        }
    }

    private static class EventType {
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType FILTER_WRITE = new EventType("FILTER_WRITE");
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

