/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe.support;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.common.support.BaseIoSession;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeFilterChain;

public class VmPipeSessionImpl
extends BaseIoSession {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoService service;
    private final IoServiceConfig serviceConfig;
    private final IoServiceListenerSupport serviceListeners;
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final SocketAddress serviceAddress;
    private final IoHandler handler;
    private final VmPipeFilterChain filterChain;
    private final VmPipeSessionImpl remoteSession;
    private final Lock lock;
    final BlockingQueue<Object> pendingDataQueue;

    public VmPipeSessionImpl(IoService service, IoServiceConfig serviceConfig, IoServiceListenerSupport serviceListeners, SocketAddress localAddress, IoHandler handler, VmPipe remoteEntry) {
        this.service = service;
        this.serviceConfig = serviceConfig;
        this.serviceListeners = serviceListeners;
        this.lock = new ReentrantLock();
        this.localAddress = localAddress;
        this.remoteAddress = this.serviceAddress = remoteEntry.getAddress();
        this.handler = handler;
        this.filterChain = new VmPipeFilterChain(this);
        this.pendingDataQueue = new LinkedBlockingQueue<Object>();
        this.remoteSession = new VmPipeSessionImpl(this, remoteEntry);
    }

    private VmPipeSessionImpl(VmPipeSessionImpl remoteSession, VmPipe entry) {
        this.service = entry.getAcceptor();
        this.serviceConfig = entry.getConfig();
        this.serviceListeners = entry.getListeners();
        this.lock = remoteSession.lock;
        this.localAddress = this.serviceAddress = remoteSession.remoteAddress;
        this.remoteAddress = remoteSession.localAddress;
        this.handler = entry.getHandler();
        this.filterChain = new VmPipeFilterChain(this);
        this.remoteSession = remoteSession;
        this.pendingDataQueue = new LinkedBlockingQueue<Object>();
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    IoServiceListenerSupport getServiceListeners() {
        return this.serviceListeners;
    }

    @Override
    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Override
    public IoSessionConfig getConfig() {
        return CONFIG;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public VmPipeSessionImpl getRemoteSession() {
        return this.remoteSession;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void close0() {
        this.filterChain.fireFilterClose(this);
    }

    @Override
    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.VM_PIPE;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    protected void updateTrafficMask() {
        if (this.getTrafficMask().isReadable() || this.getTrafficMask().isWritable()) {
            ArrayList data = new ArrayList();
            this.pendingDataQueue.drainTo(data);
            for (Object aData : data) {
                if (aData instanceof IoFilter.WriteRequest) {
                    IoFilter.WriteRequest wr = (IoFilter.WriteRequest)aData;
                    this.filterChain.doWrite(this, wr);
                    continue;
                }
                this.filterChain.fireMessageReceived(this, aData);
            }
        }
    }

    Lock getLock() {
        return this.lock;
    }
}

