/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.XASession_9_1;
import org.wso2.andes.client.failover.FailoverException;
import org.wso2.andes.transport.XaStatus;

class XAResource_0_9_1
implements XAResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAResource_0_9_1.class);
    private final XASession_9_1 session;
    private List<XAResource> siblings = new ArrayList<XAResource>();
    private boolean joined = false;
    private int timeout;
    private Xid xid;
    private boolean pendingSessionClose = false;

    XAResource_0_9_1(XASession_9_1 xaSession_9_1) {
        this.session = xaSession_9_1;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XaStatus resultStatus;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start tx branch with xid: {}", (Object)xid);
        }
        try {
            resultStatus = this.session.commitDtx(xid, onePhase);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while committing dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        finally {
            this.xid = null;
        }
        this.closeSessionIfClosable();
        this.checkStatus(resultStatus);
    }

    private void closeSessionIfClosable() {
        if (!this.session.isClosed() && this.pendingSessionClose) {
            try {
                this.session.internalClose();
            }
            catch (JMSException e) {
                LOGGER.error("Error while closing session after commit or rollback", (Throwable)e);
            }
        }
    }

    @Override
    public void end(Xid xid, int flag) throws XAException {
        XaStatus resultStatus;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("end tx branch with xid: ", (Object)xid);
        }
        switch (flag) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                break;
            }
            case 0x2000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        try {
            resultStatus = this.session.endDtx(xid, flag);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while ending dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        this.checkStatus(resultStatus);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling end for " + this.siblings.size() + " XAResource siblings");
        }
        if (!this.joined) {
            for (XAResource sibling : this.siblings) {
                sibling.end(xid, flag);
            }
        }
        this.joined = false;
        this.siblings.clear();
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XaStatus resultStatus;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("forget tx branch with xid: ", (Object)xid);
        }
        try {
            resultStatus = this.session.forget(xid);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while forgetting dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        finally {
            this.xid = null;
        }
        this.checkStatus(resultStatus);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        throw new RuntimeException("Feature NotImplemented");
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        boolean isSameRm;
        if (this == xaResource) {
            return true;
        }
        if (!(xaResource instanceof XAResource_0_9_1)) {
            return false;
        }
        SocketAddress myRemoteAddress = this.session.getAMQConnection().getProtocolHandler().getRemoteAddress();
        SocketAddress otherRemoteAddress = ((XAResource_0_9_1)xaResource).session.getAMQConnection().getProtocolHandler().getRemoteAddress();
        boolean bl = isSameRm = myRemoteAddress != null && otherRemoteAddress != null && myRemoteAddress.equals(otherRemoteAddress);
        if (isSameRm) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("XAResource " + xaResource + " is from the same ResourceManager. Adding XAResource as " + "sibling for AMQP protocol support. ");
            }
            this.siblings.add(xaResource);
            ((XAResource_0_9_1)xaResource).siblings.add(this);
        }
        return isSameRm;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XaStatus resultStatus;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepare dtx branch with xid: " + xid);
        }
        try {
            resultStatus = this.session.prepareDtx(xid);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while preparing dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        if (resultStatus == XaStatus.XA_RDONLY) {
            return 3;
        }
        this.checkStatus(resultStatus);
        return 0;
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("recover dtx branches with prepared state");
        }
        try {
            List<Xid> xidList = this.session.recoverDtxTransactions();
            return xidList.toArray(new Xid[xidList.size()]);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while recovering dtx sessions.");
            xaException.initCause(e);
            throw xaException;
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XaStatus resultStatus;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start dtx branch with xid: ", (Object)xid);
        }
        try {
            resultStatus = this.session.rollbackDtx(xid);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while rolling back dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        finally {
            this.xid = null;
        }
        this.closeSessionIfClosable();
        this.checkStatus(resultStatus);
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        if (this.isTransactionActive()) {
            this.setDtxTimeoutInServer(timeout);
        }
        return true;
    }

    boolean isTransactionActive() {
        return this.xid != null;
    }

    private void setDtxTimeoutInServer(int timeout) throws XAException {
        XaStatus resultStatus;
        try {
            resultStatus = this.session.setDtxTimeout(this.xid, timeout);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while setting transaction timeout back dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        this.checkStatus(resultStatus);
    }

    @Override
    public void start(Xid xid, int flag) throws XAException {
        XaStatus resultStatus;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start tx branch with xid: ", (Object)xid);
        }
        switch (flag) {
            case 0: 
            case 0x200000: 
            case 0x8000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        try {
            resultStatus = this.session.startDtx(xid, flag);
        }
        catch (AMQException | FailoverException e) {
            XAException xaException = new XAException("Error while starting dtx session.");
            xaException.initCause(e);
            throw xaException;
        }
        this.checkStatus(resultStatus);
        this.xid = xid;
        if (this.timeout > 0) {
            this.setTransactionTimeout(this.timeout);
        }
        if (flag == 0x200000) {
            this.joined = true;
        }
    }

    private void checkStatus(XaStatus status) throws XAException {
        switch (status) {
            case XA_OK: {
                break;
            }
            case XA_RBROLLBACK: {
                throw new XAException(100);
            }
            case XA_RBTIMEOUT: {
                throw new XAException(106);
            }
            case XA_HEURHAZ: {
                throw new XAException(8);
            }
            case XA_HEURCOM: {
                throw new XAException(7);
            }
            case XA_HEURRB: {
                throw new XAException(6);
            }
            case XA_HEURMIX: {
                throw new XAException(5);
            }
            case XA_RDONLY: {
                throw new XAException(3);
            }
            default: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("got unexpected status value: {}", (Object)status);
                }
                throw new XAException(-3);
            }
        }
    }

    boolean indicateSessionClosure() throws JMSException {
        this.pendingSessionClose = true;
        return this.isTransactionActive();
    }
}

