/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.client.message.AMQMessageDelegate;
import org.wso2.andes.client.message.AMQMessageDelegateFactory;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.client.util.ClassLoadingAwareObjectInputStream;

public class JMSObjectMessage
extends AbstractJMSMessage
implements ObjectMessage {
    public static final String MIME_TYPE = "application/java-object-stream";
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    public JMSObjectMessage(AMQMessageDelegateFactory delegateFactory) {
        this(delegateFactory, null);
    }

    private JMSObjectMessage(AMQMessageDelegateFactory delegateFactory, ByteBuffer data) {
        super(delegateFactory, data);
        if (data == null) {
            this._data = ByteBuffer.allocate(1024);
            this._data.setAutoExpand(true);
        }
        this.setContentType(this.getMimeType());
    }

    JMSObjectMessage(AMQMessageDelegate delegate, ByteBuffer data) throws AMQException {
        super(delegate, data);
    }

    @Override
    public void clearBodyImpl() throws JMSException {
        if (this._data != null) {
            this._data.release();
            this._data = null;
        }
    }

    @Override
    public String toBodyString() throws JMSException {
        return "Not Supported ..";
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    public void setObject(Serializable serializable) throws JMSException {
        this.checkWritable();
        if (this._data == null) {
            this._data = ByteBuffer.allocate(1024);
            this._data.setAutoExpand(true);
        } else {
            this._data.rewind();
        }
        try {
            ObjectOutputStream out = new ObjectOutputStream(this._data.asOutputStream());
            out.writeObject(serializable);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            MessageFormatException mfe = new MessageFormatException("Message not serializable: " + e);
            mfe.setLinkedException((Exception)e);
            mfe.initCause((Throwable)e);
            throw mfe;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable getObject() throws JMSException {
        Serializable serializable;
        ClassLoadingAwareObjectInputStream in = null;
        if (this._data == null) {
            return null;
        }
        try {
            this._data.rewind();
            in = new ClassLoadingAwareObjectInputStream(this._data.asInputStream());
            serializable = (Serializable)in.readObject();
        }
        catch (IOException e) {
            try {
                MessageFormatException mfe = new MessageFormatException("Could not deserialize message: " + e);
                mfe.setLinkedException((Exception)e);
                mfe.initCause((Throwable)e);
                throw mfe;
                catch (ClassNotFoundException e2) {
                    mfe = new MessageFormatException("Could not deserialize message: " + e2);
                    mfe.setLinkedException((Exception)e2);
                    mfe.initCause((Throwable)e2);
                    throw mfe;
                }
            }
            catch (Throwable throwable) {
                JMSObjectMessage.close(in);
                throw throwable;
            }
        }
        JMSObjectMessage.close(in);
        return serializable;
    }

    private static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

