/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQChannelException;
import org.wso2.andes.AMQConnectionException;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrame;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.Content;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.andes.framing.FieldTable;
import org.wso2.andes.protocol.AMQConstant;
import org.wso2.andes.protocol.AMQVersionAwareProtocolSession;

public abstract class AMQMethodBodyImpl
implements AMQMethodBody {
    public static final byte TYPE = 1;

    @Override
    public byte getFrameType() {
        return 1;
    }

    protected abstract int getBodySize();

    @Override
    public AMQFrame generateFrame(int channelId) {
        return new AMQFrame(channelId, this);
    }

    @Override
    public AMQChannelException getChannelNotFoundException(int channelId) {
        return this.getChannelException(AMQConstant.NOT_FOUND, "Channel not found for id:" + channelId);
    }

    @Override
    public AMQChannelException getChannelException(AMQConstant code, String message) {
        return new AMQChannelException(code, message, this.getClazz(), this.getMethod(), this.getMajor(), this.getMinor(), null);
    }

    @Override
    public AMQChannelException getChannelException(AMQConstant code, String message, Throwable cause) {
        return new AMQChannelException(code, message, this.getClazz(), this.getMethod(), this.getMajor(), this.getMinor(), cause);
    }

    @Override
    public AMQConnectionException getConnectionException(AMQConstant code, String message) {
        return new AMQConnectionException(code, message, this.getClazz(), this.getMethod(), this.getMajor(), this.getMinor(), null);
    }

    @Override
    public AMQConnectionException getConnectionException(AMQConstant code, String message, Throwable cause) {
        return new AMQConnectionException(code, message, this.getClazz(), this.getMethod(), this.getMajor(), this.getMinor(), cause);
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws AMQException {
        session.methodFrameReceived(channelId, this);
    }

    @Override
    public int getSize() {
        return 4 + this.getBodySize();
    }

    @Override
    public void writePayload(ByteBuffer buffer) {
        EncodingUtils.writeUnsignedShort(buffer, this.getClazz());
        EncodingUtils.writeUnsignedShort(buffer, this.getMethod());
        this.writeMethodPayload(buffer);
    }

    protected byte readByte(ByteBuffer buffer) {
        return buffer.get();
    }

    protected AMQShortString readAMQShortString(ByteBuffer buffer) {
        return EncodingUtils.readAMQShortString(buffer);
    }

    protected int getSizeOf(AMQShortString string) {
        return EncodingUtils.encodedShortStringLength(string);
    }

    protected void writeByte(ByteBuffer buffer, byte b) {
        buffer.put(b);
    }

    protected void writeAMQShortString(ByteBuffer buffer, AMQShortString string) {
        EncodingUtils.writeShortStringBytes(buffer, string);
    }

    protected int readInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    protected void writeInt(ByteBuffer buffer, int i) {
        buffer.putInt(i);
    }

    protected FieldTable readFieldTable(ByteBuffer buffer) throws AMQFrameDecodingException {
        return EncodingUtils.readFieldTable(buffer);
    }

    protected int getSizeOf(FieldTable table) {
        return EncodingUtils.encodedFieldTableLength(table);
    }

    protected void writeFieldTable(ByteBuffer buffer, FieldTable table) {
        EncodingUtils.writeFieldTableBytes(buffer, table);
    }

    protected long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    protected void writeLong(ByteBuffer buffer, long l) {
        buffer.putLong(l);
    }

    protected int getSizeOf(byte[] response) {
        return response == null ? 4 : response.length + 4;
    }

    protected void writeBytes(ByteBuffer buffer, byte[] data) {
        EncodingUtils.writeBytes(buffer, data);
    }

    protected byte[] readBytes(ByteBuffer buffer) {
        return EncodingUtils.readBytes(buffer);
    }

    protected short readShort(ByteBuffer buffer) {
        return EncodingUtils.readShort(buffer);
    }

    protected void writeShort(ByteBuffer buffer, short s) {
        EncodingUtils.writeShort(buffer, s);
    }

    protected Content readContent(ByteBuffer buffer) {
        return null;
    }

    protected int getSizeOf(Content body) {
        return 0;
    }

    protected void writeContent(ByteBuffer buffer, Content body) {
    }

    protected byte readBitfield(ByteBuffer buffer) {
        return this.readByte(buffer);
    }

    protected int readUnsignedShort(ByteBuffer buffer) {
        return buffer.getUnsignedShort();
    }

    protected void writeBitfield(ByteBuffer buffer, byte bitfield0) {
        buffer.put(bitfield0);
    }

    protected void writeUnsignedShort(ByteBuffer buffer, int s) {
        EncodingUtils.writeUnsignedShort(buffer, s);
    }

    protected long readUnsignedInteger(ByteBuffer buffer) {
        return buffer.getUnsignedInt();
    }

    protected void writeUnsignedInteger(ByteBuffer buffer, long i) {
        EncodingUtils.writeUnsignedInteger(buffer, i);
    }

    protected short readUnsignedByte(ByteBuffer buffer) {
        return buffer.getUnsigned();
    }

    protected void writeUnsignedByte(ByteBuffer buffer, short unsignedByte) {
        EncodingUtils.writeUnsignedByte(buffer, unsignedByte);
    }

    protected long readTimestamp(ByteBuffer buffer) {
        return EncodingUtils.readTimestamp(buffer);
    }

    protected void writeTimestamp(ByteBuffer buffer, long t) {
        EncodingUtils.writeTimestamp(buffer, t);
    }
}

