/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_8_0;

import org.apache.mina.common.ByteBuffer;
import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.BasicRejectBody;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.amqp_8_0.AMQMethodBody_8_0;
import org.wso2.andes.framing.amqp_8_0.MethodDispatcher_8_0;

public class BasicRejectBodyImpl
extends AMQMethodBody_8_0
implements BasicRejectBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new BasicRejectBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 90;
    private final long _deliveryTag;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public BasicRejectBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._deliveryTag = this.readLong(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public BasicRejectBodyImpl(long deliveryTag, boolean requeue) {
        this._deliveryTag = deliveryTag;
        byte bitfield0 = 0;
        if (requeue) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 90;
    }

    @Override
    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    @Override
    public final boolean getRequeue() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 9;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeLong(buffer, this._deliveryTag);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchBasicReject(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicRejectBodyImpl: ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("requeue=");
        buf.append(this.getRequeue());
        buf.append("]");
        return buf.toString();
    }
}

