/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class ExchangeUnbind
extends Method {
    public static final int TYPE = 1797;
    private short packing_flags = 0;
    private String queue;
    private String exchange;
    private String bindingKey;

    @Override
    public final int getStructType() {
        return 1797;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public ExchangeUnbind() {
    }

    public ExchangeUnbind(String queue, String exchange, String bindingKey, Option ... _options) {
        if (queue != null) {
            this.setQueue(queue);
        }
        if (exchange != null) {
            this.setExchange(exchange);
        }
        if (bindingKey != null) {
            this.setBindingKey(bindingKey);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.exchangeUnbind(context, this);
    }

    public final boolean hasQueue() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ExchangeUnbind clearQueue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.queue = null;
        this.dirty = true;
        return this;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final ExchangeUnbind setQueue(String value) {
        this.queue = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final ExchangeUnbind queue(String value) {
        return this.setQueue(value);
    }

    public final boolean hasExchange() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ExchangeUnbind clearExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.exchange = null;
        this.dirty = true;
        return this;
    }

    public final String getExchange() {
        return this.exchange;
    }

    public final ExchangeUnbind setExchange(String value) {
        this.exchange = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final ExchangeUnbind exchange(String value) {
        return this.setExchange(value);
    }

    public final boolean hasBindingKey() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ExchangeUnbind clearBindingKey() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.bindingKey = null;
        this.dirty = true;
        return this;
    }

    public final String getBindingKey() {
        return this.bindingKey;
    }

    public final ExchangeUnbind setBindingKey(String value) {
        this.bindingKey = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.dirty = true;
        return this;
    }

    public final ExchangeUnbind bindingKey(String value) {
        return this.setBindingKey(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.queue);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.exchange);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeStr8(this.bindingKey);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.queue = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.exchange = dec.readStr8();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.bindingKey = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("queue", this.getQueue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("exchange", this.getExchange());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("bindingKey", this.getBindingKey());
        }
        return result;
    }
}

